require "Dialogs"

Animation = "None"
vel = 0
BackgroundTimer = 0
frecuencia = 0
GlowMax = 0.7
GlowTimer = 0
tableaux = 0
velanim = 1
fadeGlow = true

LegsParts = {}
Sans = {Animation = "None", Timer = 0, Direction = 1}
Undyne = {Animation = "None", Timer = 0}
Squares = {}
Titles = {{"Murderer", "Asesino", "Убийца"}, {"Last Chance", "Último Chance", "Последний Шанс"}, {"Regret", "Arrepentimiento", "Сожаление"}, {"Traitor", "Traidor", "Предатель"}, {"Words can hurt", "Las palabras pueden lastimar", "Слова могут ранить"}, {"Captured Human", "Humano Capturado", "Пойманый человек"}, {"Hide and Seek", "Escondite", "Прятки"}, {"EGG", "EGG", "ЯЙЦО"}, {"Investigator", "Investigador", "Инспектор"}, {"Coward", "Cobarde", "Трус"}, {"Manipulator", "Manipulador", "Кукловод"}, {"I'm not hungry", "No tengo hambre", "Я не голоден"}, {"Pasta Master", "Maestro de Pasta", "Мастер Пасты"}, {"UnderCraft", "UnderCraft", "UnderCraft"}, {"A new challenger has appeared", "Un nuevo retador a aparecido", "Появился новый соперник!"}, {"DON'T TOUCH THE CHILD!", "NO TOQUES AL NIÑO!", "НЕ ТРОЖЬ ДИТЯ!"}, {"Do you have a life?!", "Tienes una vida?!", "У тебя есть жизнь?!"}, {"SPOOKY", "Espantoso", "СТРАШНА ВЫРУБАЙ"}, {"Double Lesson", "Doble Lección", "Двойной Урок"}, {"Perseverance", "Perseverancia", "Настойчивость"}, {"Annoying Dog", "Perro Molesto", "Надоедливый Пёс"}, {"Dirty Killer Brother", "Sucio Asesino de Hermanos", "Грязный Убийца Брата"}, {"Spaghetti Murder", "Asesinato de Spaghetti", "Убийство Спагетти"}, {"I'm out of here", "Me voy de aquí", "Я сваливаю"}, {"The Comedian", "El Comediante", "Комик"}, {"SIKE!", "SIKE!", "SIKE!"}}
CreateLayer("OverTop", "Top", false)

function SpawnPapyrus()
	Legs = CreateSprite("Papyrus/Legs/Normal","Bottom")
	Body = CreateSprite("Papyrus/Body/Disbelief","Bottom")
	Jaw = CreateSprite("Papyrus/Jaw","Bottom")
	Head = CreateSprite("Papyrus/Head/Phase 1/Disappointed","Bottom")
	Glow = CreateSprite("Papyrus/Glow/1","Bottom")
	Glow.SetAnimation({"Papyrus/Glow/1","Papyrus/Glow/2","Papyrus/Glow/3","Papyrus/Glow/2"}, 0.08)
	Body.SetParent(Legs)
	Jaw.SetParent(Body)
	Head.SetParent(Body)
	Glow.SetParent(Head)
	Legs.MoveTo(320, 285)
	Body.MoveTo(0, 70)
	Head.MoveTo(4, 60)
	Jaw.MoveTo(Head.x, Head.y - 22)
	Glow.MoveTo(-32, 20)
	Glow.alpha = 0.75
end

function SpawnSans()
	Sans.Legs = CreateSprite("Sans/Legs","Top")
	Sans.Body = CreateSprite("Sans/Body/Left","Top")
	Sans.Head = CreateSprite("Sans/Head/Angry","Top")
	Sans.Body.SetParent(Sans.Legs)
	Sans.Head.SetParent(Sans.Body)
	Sans.Legs.MoveTo(320, 261)
	Sans.Body.MoveTo(-2, 48)
	Sans.Head.MoveTo(0, 43)
	Sans.Color = 0.5
end

function SpawnUndyne()
	Undyne.Legs = CreateSprite("Undyne/Legs")
	Undyne.Dress = CreateSprite("Undyne/Dress") --I know it's not a dress but it looks like one so fuck it xd
	Undyne.Torso = CreateSprite("Undyne/Torso")
	Undyne.Arms = {Left = CreateSprite("Undyne/ArmL"), Right = CreateSprite("Undyne/ArmR")}
	Undyne.Head = CreateSprite("Undyne/Head/Normal")
	Undyne.Hair = CreateSprite("Undyne/Hair")
	Undyne.Eye = CreateSprite("Undyne/Eye") --It's not an actual eye, but it appears in its eye so I call it eye
	Undyne.Dress.SetPivot(0.6, 0.8)
	Undyne.Torso.SetPivot(0.15, 0.6)
	Undyne.Hair.SetPivot(0.92, 0.02)
	Undyne.Eye.SetPivot(0, 0.5)
	Undyne.Arms.Left.SetPivot(82/92, 150/152)
	Undyne.Arms.Left.SetParent(Undyne.Legs)
	Undyne.Arms.Right.SetParent(Undyne.Legs)
	Undyne.Hair.SetParent(Undyne.Legs)
	Undyne.Torso.SetParent(Undyne.Legs)
	Undyne.Dress.SetParent(Undyne.Legs)
	Undyne.Head.SetParent(Undyne.Legs)
	Undyne.Eye.SetParent(Undyne.Head)
	Undyne.Legs.MoveTo(320, 278)
	Undyne.Torso.MoveTo(-53, 120)
	Undyne.Eye.MoveTo(9, 0)
	Undyne.Eye.alpha = 0
	Undyne.Animation = "Idle" --I need to start using this word instead of "Normal", doesn't matter but I think it's for the best
end

function DoReset(value)
	Reset(value)
end

function AnimatePapyrus()
	DialogUpdate()
	if LogroDesbloqueado then
		LogroDesbloqueado.Timer = LogroDesbloqueado.Timer + 1
		if not CajaL then
			CajaL = CreateSprite("Specials/Box", "OverTop")
			CajaL.MoveTo(485, -25)
			PictureL = CreateSprite("Menu/Archievements/"..LogroDesbloqueado.Icon)
			PictureL.SetParent(CajaL)
			PictureL.Scale(0.5, 0.5)
			PictureL.MoveTo(-125, -4)
			if LogroDesbloqueado.Icon <= 6 or LogroDesbloqueado.Icon == 8 or (LogroDesbloqueado.Icon >= 11 and LogroDesbloqueado.Icon <= 14) or LogroDesbloqueado.Icon == 26 then
				Audio.PlaySound("logro")
			else
				Audio.PlaySound("mysterious")
			end
		end
		if LogroDesbloqueado.Timer <= 30 then
			CajaL.y = -25 + 50/30*LogroDesbloqueado.Timer
		elseif LogroDesbloqueado.Timer > 180 and LogroDesbloqueado.Timer <= 210 then
			CajaL.y = 25 - 50/30*(LogroDesbloqueado.Timer - 180)
		end
		local acumulador = 0
		local desbloqueo = "Achievement Unlocked!"
		if GetAlMightyGlobal("Idioma") == "Spanish" then
			acumulador = 1
			desbloqueo = "Logro Desbloqueado!"
		elseif GetAlMightyGlobal("Idioma") == "Russian" then
			acumulador = 2
			desbloqueo = "Достижение разблокировано!"
		end
		if not Texto1 then
			Texto1 = CreateText("[instant][novoice][font:uidialog][color:ffff00]"..desbloqueo, {0, 0}, 600, "OverTop")
			Texto1.SetParent(CajaL)
			Texto1.Scale(0.5, 0.5)
			Texto1.progressmode = "none"
			Texto1.HideBubble()
			Texto2 = CreateText("[instant][novoice][font:uidialog][color:ffffff]"..Titles[LogroDesbloqueado.Icon][1 + acumulador], {0, 0}, 600, "OverTop")
			Texto2.SetParent(CajaL)
			Texto2.Scale(0.5, 0.5)
			Texto2.progressmode = "none"
			Texto2.HideBubble()
			Texto1.MoveTo(-98, 1)
			Texto2.MoveTo(-98, -17)
		end
		if LogroDesbloqueado.Timer >= 211 then
			Texto1.Remove()
			Texto1 = nil
			Texto2.Remove()
			Texto2 = nil
			PictureL.Remove()
			PictureL = nil
			CajaL.Remove()
			CajaL = nil
			LogroDesbloqueado = nil
		end
	end
	if BackgroundAnimation then
		BackgroundTimer = BackgroundTimer + 1
		BG1.yscale = (228 + 6*math.sin(math.rad(90 + BackgroundTimer)))/206
		BG2.yscale = (233 + 17*math.sin(math.rad(90 + BackgroundTimer*1.5)))/206
		BG2.color = {(144 + 111*math.cos(math.rad(BackgroundTimer)))/255, (211 + 14*math.cos(math.rad(BackgroundTimer)))/255, (127.5 - 127.5*math.cos(math.rad(BackgroundTimer)))/255}
		if BackgroundAnimation == "Normal" and BGY < -10 then
			BGY = math.min(BGY + 30, -10)
		elseif BackgroundAnimation == "Fade" and BGY > -310 then
			BGY = math.max(BGY - 0.2, -310)
		elseif BackgroundAnimation == "Increase" and BGY < -10 then
			BGY = math.min(BGY + 0.2, -10)
		elseif BackgroundAnimation == "Fall" and BGY > -310 then
			BGY = math.max(BGY - 10, -310)
		end
		BG1.MoveTo(320, BGY + 103*BG1.yscale)
		BG2.MoveTo(320, BGY + 103*BG2.yscale)
		if BackgroundTimer%10 == 0 and not summon and not safe and BGY > -310 then
			table.insert(Squares, {Sprite = CreateSprite("Rotatory Arena Pixel","BelowArena"), X = math.random(5, 635), Y = BGY - 20, Scale = 20, Alpha = 0.5, Rotation = math.random(2, 4)*(-3 + 2*math.random(2))})
			RelayerUI("BelowArena")
		end
	end
	for i=1,#Squares do
		local Datos = Squares[i - tableaux]
		Datos.Y = Datos.Y + 2
		Datos.Scale = Datos.Scale - 30/180
		Datos.Alpha = Datos.Alpha - 0.5/90
		Datos.Sprite.rotation = Datos.Sprite.rotation + Datos.Rotation
		Datos.Sprite.Scale(Datos.Scale, Datos.Scale)
		Datos.Sprite.color = {0,0,0}
		Datos.Sprite.alpha = Datos.Alpha
		Datos.Sprite.MoveTo(Datos.X, Datos.Y)
		if Datos.Alpha <= 0 then
			Datos.Sprite.Remove()
			Datos.Sprite = nil
			table.remove(Squares, i - tableaux)
			tableaux = tableaux + 1
		end
	end
	tableaux = 0
	if Undyne.Animation == "Idle" then
		Undyne.Timer = Undyne.Timer + 1
		Undyne.Dress.rotation = math.sin(Undyne.Timer/60*(1.15 * 6.5))*3
		Undyne.Dress.MoveTo(10, 54 + math.sin(-Undyne.Timer/60*(1.15 * 6.5)))
		Undyne.Torso.rotation = -math.sin(Undyne.Timer/60*(1.15 * 6.5))*4
		Undyne.Head.MoveTo(2, 160 + math.sin(-Undyne.Timer/60*(1.15 * 6.5))*3)
		if not Undyne.Arms.Left.GetVar("Timer") then
			Undyne.Arms.Left.MoveTo(-22 + math.sin(Undyne.Timer/60*(1.15 * 6.5))*5, 116 + math.sin(-Undyne.Timer/60*(1.15 * 6.5))*5)
		else
			Undyne.Arms.Left.SetVar("Timer", Undyne.Arms.Left.GetVar("Timer") + 1)
			if not Undyne.Arms.Left.GetVar("X") then
				Undyne.Arms.Left.SetVar("X", -22 + math.sin(Undyne.Timer/60*(1.15 * 6.5))*5)
				Undyne.Arms.Left.SetVar("Y", 116 + math.sin(-Undyne.Timer/60*(1.15 * 6.5))*5)
				Undyne.Arms.Left.SetVar("GoX", -46 - Undyne.Arms.Left.GetVar("X"))
				Undyne.Arms.Left.SetVar("GoY", 106 - Undyne.Arms.Left.GetVar("Y"))
			end
			if Undyne.Arms.Left.GetVar("Timer") <= 5 then
				Undyne.Arms.Left.MoveTo(Undyne.Arms.Left.GetVar("X") + Undyne.Arms.Left.GetVar("GoX")/5*Undyne.Arms.Left.GetVar("Timer"), Undyne.Arms.Left.GetVar("Y") + Undyne.Arms.Left.GetVar("GoY")/5*Undyne.Arms.Left.GetVar("Timer"))
				Undyne.Arms.Left.rotation = -105/5*Undyne.Arms.Left.GetVar("Timer")
			elseif Undyne.Arms.Left.GetVar("Timer") > 10 and Undyne.Arms.Left.GetVar("Timer") <= 15 then
				Undyne.Arms.Left.SendToTop()
				Undyne.Arms.Left.MoveTo(-46 + 10/5*(Undyne.Arms.Left.GetVar("Timer") - 10), 106 + 18/5*(Undyne.Arms.Left.GetVar("Timer") - 10))
				Undyne.Arms.Left.rotation = -105 + 180/5*(Undyne.Arms.Left.GetVar("Timer") - 10)
				if Undyne.Arms.Left.GetVar("Timer") >= 15 and not summon then
					Rafaga1 = CreateSprite("Undyne/Rafaga 1","Top")
					Rafaga1.SetAnimation({"Undyne/Rafaga 1","Undyne/Rafaga 2"}, 0.04)
					Rafaga1.MoveTo(Undyne.Legs.x - 42, Undyne.Legs.y + 32)
					Rafaga2 = CreateSprite("Undyne/Rafaga 1","Top")
					Rafaga2.SetAnimation({"Undyne/Rafaga 1","Undyne/Rafaga 2"}, 0.04)
					Rafaga2.MoveTo(Rafaga1.x, Rafaga1.y)
					Player.sprite.color = {0, 192/255, 0}
				end
			elseif Undyne.Arms.Left.GetVar("Timer") > 25 and Undyne.Arms.Left.GetVar("Timer") <= 35 then
				Undyne.Arms.Left.MoveTo(-36 + 14/10*(Undyne.Arms.Left.GetVar("Timer") - 25), 124 - 8/10*(Undyne.Arms.Left.GetVar("Timer") - 25))
				Undyne.Arms.Left.rotation = 75 - 75/10*(Undyne.Arms.Left.GetVar("Timer") - 25)
				if Undyne.Arms.Left.GetVar("Timer") >= 35 then
					Undyne.Arms.Left.SendToBottom()
					Undyne.Arms.Left.SetVar("Timer", nil)
				end
			end
		end
		Undyne.Arms.Right.MoveTo(48 + math.sin(-Undyne.Timer/60*(1.15 * 6.5)*2)*4, 75 + math.sin(-Undyne.Timer/60*(1.15 * 6.5))*7)
		Undyne.Hair.rotation = 60 - (math.sin(Undyne.Timer/60*(1.15 * 6.5))*10)
		Undyne.Hair.MoveTo(-12, Undyne.Head.y + 22)
		Undyne.Eye.rotation = math.sin(3/60*Undyne.Timer)*35
		if Undyne.Timer%150 == 0 and not Undyne.DontShow then
			Undyne.Eye.alpha = 1
			Undyne.Eye.xscale = 0.5
		end
		if Undyne.Eye.alpha > 0 and not summon then
			Undyne.Eye.alpha = Undyne.Eye.alpha - 0.015
			Undyne.Eye.xscale = Undyne.Eye.xscale + 0.05
		end
	elseif Undyne.Animation == "Hurt" then
		Undyne.Timer = Undyne.Timer + 1
		Undyne.Dress.rotation = 0
		Undyne.Dress.MoveTo(10, 54)
		Undyne.Torso.rotation = 0
		Undyne.Head.MoveTo(2, 160)
		Undyne.Arms.Right.MoveTo(48, 75)
		Undyne.Arms.Left.MoveTo(-22, 116)
		Undyne.Hair.rotation = 60
		Undyne.Hair.MoveTo(-12, Undyne.Head.y + 22)
		Undyne.Eye.rotation = 0
		Undyne.Eye.alpha = 0
		if Undyne.Timer == 1 or Undyne.Timer == 81 then
			if Undyne.Timer == 1 then
				Undyne.Head.Set("Undyne/Head/Hurt")
				if StatusPhase3[3] ~= "Fake Attack" then
					for i=1,3 do
						Audio.PlaySound("damage")
					end
				end
			else
				Undyne.Head.Set("Undyne/Head/Normal")
				Undyne.Timer = 0
				Undyne.Animation = "Idle"
			end
			Undyne.Legs.MoveTo(Undyne.Legs.x + 10, Undyne.Legs.y)
		elseif Undyne.Timer%20 == 1 then
			Undyne.Legs.MoveTo(Undyne.Legs.x + 20, Undyne.Legs.y)
		elseif Undyne.Timer%20 == 11 then
			Undyne.Legs.MoveTo(Undyne.Legs.x - 20, Undyne.Legs.y)
		end
	end
	if Rafaga1 and not summon then
		Rafaga1.alpha = Rafaga1.alpha - 0.05
		Rafaga2.alpha = Rafaga1.alpha
		Rafaga2.MoveTo(Rafaga2.x, Rafaga2.y - 20)
		if Rafaga1.alpha <= 0 then
			Rafaga1.Remove()
			Rafaga2.Remove()
			Rafaga1 = nil
			Rafaga2 = nil
		end
	end
	if laughtimer then
		laughtimer = laughtimer + 1
		if laughtimer == 66 then
			Undyne.Head.Set("Undyne/Head/Normal")
			laughtimer = nil
		elseif laughtimer%20 == 1 then
			Undyne.Head.Set("Undyne/Head/Laugh 1")
		elseif laughtimer%20 == 6 then
			Undyne.Head.Set("Undyne/Head/Laugh 2")
		elseif laughtimer%20 == 11 then
			Undyne.Head.Set("Undyne/Head/Laugh 3")
		elseif laughtimer%20 == 16 then
			Undyne.Head.Set("Undyne/Head/Laugh 2")
		end
	end
	if Animation == "Phase 1" then
		vel = vel + 4
		Body.MoveTo(0, 70 + 2*math.sin(math.rad(vel)))
		Head.MoveTo(4, 62 + 1*math.sin(math.rad(vel)))
		Jaw.MoveTo(Head.x, Head.y - 21 + 1*math.sin(math.rad(vel)))
	elseif Animation == "Block Phase 1" then
		if not tempStop then
			vel = vel + 1
		end
		if vel%3 == 0 and vel >= 15 and vel <= 30 then
			frecuencia = frecuencia + 2
			Arms.MoveTo(320 + math.random(-frecuencia,frecuencia), 360 + math.random(-frecuencia,frecuencia))
			Legs.MoveTo(320 + math.random(-frecuencia,frecuencia)/2, 285 + math.random(-frecuencia,frecuencia)/2)
		elseif vel == 31 then
			Arms.MoveTo(320, 360)
			Legs.MoveTo(320, 285)
			if Animation == "Ouch" then
				tempStop = true
			end
		elseif vel == 100 then
			ResetAnim()
		end
	elseif Animation == "Crying" and not AnimationHead and not AnimationHands and not StopAnim then
		vel = vel + 1
		if vel <= 0 then
			if vel > -341 and vel <= -251 then
				if not HR and not HL then
					Head.Set("Papyrus/Head/Phase 1/WAAA~")
					HR = CreateSprite("Papyrus/Arms/Crying Right Hand","BelowUI")
					HL = CreateSprite("Papyrus/Arms/Crying Left Hand","BelowUI")
					Head.MoveTo(4, 60)
					HR.SetPivot(46/50, 4/70)
					HL.SetPivot(4/52, 4/74)
					HR.MoveTo(366, 326)
					HL.MoveTo(272, 322)
				end
				HR.rotation = -20*math.sin(math.rad(vel + 341))
				HL.rotation = 20*math.sin(math.rad(vel + 341))
			elseif vel > -151 and vel <= -31 then
				Head.MoveTo(4, 60 + 8/120*(vel + 151))
				HR.rotation = -20 - 10*math.sin(math.rad(90/120*(vel + 151)))
				HL.rotation = 20 + 10*math.sin(math.rad(90/120*(vel + 151)))
			elseif vel > -31 and vel <= -1 then
				Head.MoveTo(4, 68 - 8/30*(vel + 31))
				HR.rotation = -30 + 30*math.sin(math.rad(3*(vel + 31)))
				HL.rotation = 30 - 30*math.sin(math.rad(3*(vel + 31)))
			elseif vel == 0 then
				Head.Set("Papyrus/Head/Phase 1/Why...")
				Head.MoveTo(4, 42)
				if HR and HL then
					HR.Remove()
					HL.Remove()
					HR = nil
					HL = nil
				end
			end
		else
			if vel%40 == 20 then
				Head.MoveTo(4, 44)
			elseif vel%40 == 0 then
				Head.MoveTo(4, 42)
			end
		end
	elseif Animation == "Betrayal" then
		if not tempStop then
			vel = vel + 1
		end
		if vel > 0 and vel <= 60 then
			PapsMoveTo(320 + (30 - 5*vel/10)*math.sin(math.rad(360/10*vel)), 268)
			if HR and HL then
				HR.MoveTo(391 + (30 - 5*vel/10)*math.sin(math.rad(360/10*vel)), 291)
				HL.MoveTo(246 + (30 - 5*vel/10)*math.sin(math.rad(360/10*vel)), 285)
			end
		elseif vel > 60 and vel <= 100 then
			if Body and Legs and Glow and HR and HL then
				Jaw2 = CreateSprite("Papyrus/Jaw","Bottom")
				Head2 = CreateSprite("Papyrus/Head/Phase 1/Disappointed","Bottom")
				Head.Remove()
				Jaw.Remove()
				Glow.Remove()
				Body.Dust(true)
				Legs.Dust(true)
				HR.Dust(true)
				HL.Dust(true)
				Glow = nil
				Head = Head2
				Jaw = Jaw2
				Body = nil
				Legs = nil
				HR = nil
				HL = nil
			end
			Head.MoveTo(324, 379 - 110 + 110*math.cos(math.rad(90/40*(vel - 60))))
			Head.rotation = -100/40*(vel - 60)
			Jaw.MoveTo(Head.x + (20 + 6/40*(vel - 60))*math.sin(math.rad(Head.rotation)), Head.y - (20 + 6/40*(vel - 60))*math.cos(math.rad(Head.rotation)))
			Jaw.rotation = Head.rotation
		elseif vel > 100 and vel <= 130 then
			if not Cracked then
				Audio.PlaySound("damage")
				Head.Set("Papyrus/Head/Phase 1/...")
				Bone.Set("Bullets/Bones/Broken Bone")
				Bone.SetVar("velfall", -2)
				Bone.SetVar("Bounce", 3)
				Bone.rotation = 0
				Cracked = true
			end
			Head.MoveTo(324 - 20/35*(vel - 100), 269 + 20*math.sin(math.rad(180/30*(vel - 100))))
			Head.rotation = -100 + 20/35*(vel - 100)
			Jaw.MoveTo(Head.x + 26*math.sin(math.rad(Head.rotation)), Head.y - 26*math.cos(math.rad(Head.rotation)))
			Jaw.rotation = Head.rotation
		elseif vel > 130 and vel <= 135 then
			Head.MoveTo(324 - 20/35*(vel - 100), 269 - 10/5*(vel - 130))
			Head.rotation = -100 + 20/35*(vel - 100)
			Jaw.MoveTo(Head.x + 26*math.sin(math.rad(Head.rotation)), Head.y - 26*math.cos(math.rad(Head.rotation)))
			Jaw.rotation = Head.rotation
		elseif vel > 135 and vel <= 155 then
			Head.MoveTo(304 + 8/20*(vel - 135), 259 + 10*math.sin(math.rad(9*(vel - 135))))
			Head.rotation = -80 - 10/20*(vel - 135)
			Jaw.MoveTo(Head.x + 26*math.sin(math.rad(Head.rotation)), Head.y - 26*math.cos(math.rad(Head.rotation)))
			Jaw.rotation = Head.rotation
		elseif vel == 271 then
			Jaw.Set("Papyrus/Death Jaw")
			Head.Set("Papyrus/Head/Phase 1/Death")
			Jaw.Dust(true)
			Head.Dust(true)
			Jaw = nil
			Head = nil
		end
	elseif Animation == "Ouch" then
		vel = vel + 1
		if vel == 1 then
			for i=1,3 do
				Audio.PlaySound("damage")
			end
			Black1 = CreateSprite("Bullets/Bones/Body","Top")
			Black1.Scale(640/5, 150)
			Black1.color = {0, 0, 0}
			Black1.alpha = 0
			Black1.MoveTo(320, 160)
			Black2 = CreateSprite("Bullets/Bones/Body","Top")
			Black2.Scale(640/5, 50)
			Black2.color = {0, 0, 0}
			Black2.alpha = 0
			Black2.MoveTo(320, 25)
			Black3 = CreateSprite("Bullets/Bones/Body","Top")
			Black3.Scale(170/5, 30)
			Black3.color = {0, 0, 0}
			Black3.alpha = 0
			Black3.MoveTo(305, 65)
			Black4 = CreateSprite("Bullets/Bones/Body","Top")
			Black4.Scale(250/5, 30)
			Black4.color = {0, 0, 0}
			Black4.alpha = 0
			Black4.MoveTo(515, 65)
			Black5 = CreateSprite("Bullets/Bones/Body","Top")
			Black5.Scale(120/5, 30)
			Black5.color = {0, 0, 0}
			Black5.alpha = 0
			Black5.MoveTo(60, 65)
			Black6 = CreateSprite("Bullets/Bones/Body","Top")
			Black6.Scale(100/5, 30)
			Black6.color = {0, 0, 0}
			Black6.alpha = 0
			Black6.MoveTo(170, 65)
			Head.Set("Papyrus/Head/Phase 1/Oh")
			if Arms then
				Arms.Set("Papyrus/Arms/Broken")
				Arms.MoveTo(350, 351)
			end
			Legs.MoveTo(350, 285)
		elseif vel == 16 then
			if Arms then
				Arms.MoveTo(290, 351)
			end
			Legs.MoveTo(290, 285)
		elseif vel == 31 then
			if Arms then
				Arms.MoveTo(350, 351)
			end
			Legs.MoveTo(350, 285)
		elseif vel == 46 then
			if Arms then
				Arms.MoveTo(300, 351)
			end
			Legs.MoveTo(300, 285)
		elseif vel == 56 then
			if Arms then
				Arms.MoveTo(340, 351)
			end
			Legs.MoveTo(340, 285)
			fadeGlow = true
		elseif vel == 66 then
			if Arms then
				Arms.MoveTo(310, 351)
			end
			Legs.MoveTo(310, 285)
		elseif vel == 71 then
			if Arms then
				Arms.MoveTo(330, 351)
			end
			Legs.MoveTo(330, 285)
		elseif vel == 76 then
			if Arms then
				Arms.MoveTo(315, 351)
			end
			Legs.MoveTo(315, 285)
		elseif vel == 81 then
			if Arms then
				Arms.MoveTo(320, 351)
			end
			Legs.MoveTo(320, 285)
			Animation = "None"
			vel = 0
		end
		if Black1 and Black2 and Black3 and Black4 and Black5 and Black6 then
			Black1.alpha = Black1.alpha + 1/60
			Black2.alpha = Black2.alpha + 1/60
			Black3.alpha = Black3.alpha + 1/60
			Black4.alpha = Black4.alpha + 1/60
			Black5.alpha = Black5.alpha + 1/60
			Black6.alpha = Black6.alpha + 1/60
		end
	elseif Animation == "Block Phase 2" then
		vel = vel + 1
		if vel%3 == 0 and vel >= 5 and vel <= 20 then
			frecuencia = frecuencia + 2
			Arms.MoveTo(PiernasX + 4 + math.random(-frecuencia,frecuencia), PiernasY + 90 + math.random(-frecuencia,frecuencia))
			Legs.MoveTo(PiernasX + math.random(-frecuencia,frecuencia)/2, PiernasY + math.random(-frecuencia,frecuencia)/2)
		elseif vel == 21 then
			Arms.MoveTo(PiernasX + 4, PiernasY + 90)
			Legs.MoveTo(PiernasX, PiernasY)
			Arms.Set("Papyrus/Arms/Returning")
		elseif vel == 26 then
			Arms.Set("Papyrus/Arms/Return")
			if not Slice then
				Slice = CreateSprite("UI/Battle/spr_slice_o_3","Top")
				Slice.MoveTo(Arms.x - 10, Arms.y + 20)
				Slice.SetVar("random", math.random(2))
				AnimateRepel()
			end
			if Spaghetti then
				SpaghettiDies = 0
				local positionsS = {X = Spaghetti.absx, Y = Spaghetti.absy}
				Spaghetti.Remove()
				Spaghetti = CreateSprite("Papyrus/Spaghetti","Top")
				Spaghetti.SetVar("Position", positionsS)
			end
		elseif vel == 100 then
			ResetAnim()
		end
		for i=1,#LegsParts do
			local sprite = LegsParts[i]
			sprite.MoveTo(Legs.x, Legs.y + sprite.GetVar("Y"))
		end
	elseif Animation == "Angry" then
		vel = vel + 1
		if Arms then
			Arms.Remove()
			Arms = nil
			HandL.alpha = 1
			HandR.alpha = 1
			BoneL.alpha = 1
			BoneR.alpha = 1
			Detail.alpha = 1
		end
		for i=1,#LegsParts do
			local sprite = LegsParts[i]
			sprite.MoveTo(PiernasX - sprite.GetVar("intensity")*math.sin(math.rad(360/60*vel)), PiernasY + sprite.GetVar("Y"))
		end
		Body.MoveTo(6 - LegsParts[39].GetVar("intensity")*math.sin(math.rad(360/60*vel)), 123 - 4*math.cos(math.rad(720/60*vel)))
		HandL.MoveTo(PiernasX - 45 - LegsParts[39].GetVar("intensity")*math.sin(math.rad(360/60*vel)), PiernasY + 124 - 4*math.cos(math.rad(720/60*vel)))
		HandR.MoveTo(PiernasX + 53 - LegsParts[39].GetVar("intensity")*math.sin(math.rad(360/60*vel)), PiernasY + 133 - 4*math.cos(math.rad(720/60*vel)))
		BoneR.MoveTo(PiernasX + 104 - LegsParts[39].GetVar("intensity")*math.sin(math.rad(360/60*vel)), PiernasY + 76 - 4*math.cos(math.rad(720/60*vel)))
		if vel%90 > 0 and vel%90 <= 60 then
			BoneR.rotation = 45/2 - 45/2*math.cos(math.rad(180/60*(vel%90)))
		elseif (vel%90 > 60 and vel%90 < 90) or vel%90 == 0 then
			if vel%90 == 0 then
				BoneR.rotation = 0
			else
				BoneR.rotation = 45 - 405/2 + 405/2*math.cos(math.rad(180/30*((vel%90) - 60)))
			end
		end
		if vel%180 == 0 then
			if Brillo then
				Brillo.Remove()
			end
			Brillo = CreateSprite("Papyrus/Brillo","Top")
			Brillo.SetParent(Head)
			Brillo.alpha = 0
			Brillo.SetVar("relentizado", 0)
			Brillo.MoveTo(-11, 3)
		end
	elseif Animation == "Transition" then
		vel = vel + 1
		if not diffX and not diffY then
			diffX = 6 - Body.x
			diffY = 123 - Body.y
		end
		if cambio == "Angry-Tired" then
			if not diffrot then
				diffrot = 290 - BoneR.rotation
			end
			HandL.rotation = 90/10*vel
			Detail.rotation = HandL.rotation
			HandR.rotation = -45/10*vel
			if diffrot > 180 then
				BoneR.rotation = -70 - diffrot + (diffrot - 360)/10*vel
			else
				BoneR.rotation = 290 - diffrot + diffrot/10*vel
			end
			BoneR.SetPivot((54 + (27/10*vel))/108, (53 - (24/10*vel))/106)
			HandR.Scale(1 + 0.2/10*vel, 1 + 0.2/10*vel)
			if vel >= 5 then
				HandL.Set("Papyrus/Arms/Left Tired")
				Detail.Set("Papyrus/Arms/Left Tired Detail")
				BoneL.Set("Bullets/Bones/Right Bone v2")
				BoneL.rotation = -90 + HandL.rotation
				HandL.SetPivot(49/56, 7/64)
				Detail.SetPivot(49/56, 7/64)
				Detail.MoveTo(21, -25)
				BoneL.MoveTo(-15, 16)
			end
			HandL.MoveTo(PiernasX - 45 - diffX + diffX/10*vel, PiernasY + 124 - 2/10*vel - diffY + diffY/10*vel)
			Head.MoveTo(2, 65 - 6/10*vel)
			Jaw.MoveTo(Head.x, Head.y - 26 + 6/10*vel)
			HandR.MoveTo(PiernasX + 53 - diffX + diffX/10*vel - 9/10*vel, PiernasY + 133 - diffY + diffY/10*vel - 4/10*vel)
			BoneR.MoveTo(PiernasX + 53 - diffX + diffX/10*vel - 14/10*vel + 72*math.cos(math.rad(HandR.rotation - 45)), PiernasY + 133 - diffY + diffY/10*vel - 14/10*vel + 80*math.sin(math.rad(HandR.rotation - 45)))
		elseif cambio == "Tired-Angry" then
			if not diffrot then
				diffrot = 360 - BoneR.rotation
				diffrot2 = 360 - BoneL.rotation
			end
			HandL.rotation = 90 - 90/10*vel
			Detail.rotation = HandL.rotation
			HandR.rotation = 45/10*vel
			if diffrot > 180 then
				BoneR.rotation = -diffrot + (diffrot - 360)/10*vel
			else
				BoneR.rotation = -diffrot + diffrot/10*vel
			end
			if vel >= 5 then
				HandL.Set("Papyrus/Arms/Left Angry")
				Detail.Set("Papyrus/Arms/Left Angry Detail")
				BoneL.Set("Bullets/Bones/Left Bone")
				if diffrot2 > 180 then
					BoneL.rotation = HandL.rotation - diffrot2 + (diffrot2 - 360)/10*vel
				else
					BoneL.rotation = HandL.rotation - diffrot2 + diffrot2/10*vel
				end
				HandL.SetPivot(45/52, 7/56)
				Detail.SetPivot(45/52, 7/56)
				Detail.MoveTo(19, -21)
				BoneL.MoveTo(-16, 14)
			else
				if diffrot2 > 180 then
					BoneL.rotation = HandL.rotation - 90 - diffrot2 + (diffrot2 - 360)/10*vel
				else
					BoneL.rotation = HandL.rotation - 90 - diffrot2 + diffrot2/10*vel
				end
			end
			HandL.MoveTo(PiernasX - 45 - diffX + diffX/10*vel, PiernasY + 122 + 2/10*vel - diffY + diffY/10*vel)
			BoneR.SetPivot((81 - (27/10*vel))/108, (29 + (24/10*vel))/106)
			HandR.Scale(1 - 0.2/10*vel, 1 - 0.2/10*vel)
			Head.MoveTo(2, 59 + 6/10*vel)
			Jaw.MoveTo(Head.x, Head.y - 20 - 6/10*vel)
			HandR.MoveTo(PiernasX + 44 - diffX + diffX/10*vel + 9/10*vel, PiernasY + 129 - diffY + diffY/10*vel + 4/10*vel)
			BoneR.MoveTo(PiernasX + 39 - diffX + diffX/10*vel + 14/10*vel + 72*math.cos(math.rad(HandR.rotation - 90)), PiernasY + 119 - diffY + diffY/10*vel + 14/10*vel + 80*math.sin(math.rad(HandR.rotation - 90)))
		end
		Body.MoveTo(6 - diffX + diffX/10*vel, 123 - diffY + diffY/10*vel)
		for i=1,#LegsParts do
			local sprite = LegsParts[i]
			if not sprite.GetVar("diffX") then
				sprite.SetVar("diffX", PiernasX - sprite.x)
			end
			sprite.MoveTo(PiernasX - sprite.GetVar("diffX") + sprite.GetVar("diffX")/10*vel, PiernasY + sprite.GetVar("Y"))
		end
		if vel >= 10 then
			if cambio == "Angry-Tired" then
				Animation = "Tired"
				HandR.Set("Papyrus/Arms/Right Tired")
				BoneR.Set("Bullets/Bones/Right Bone v2")
				Head.Set("Papyrus/Head/Phase 2/Tired")
				HandR.rotation = 0
				HandR.SetPivot(22/30, 111/118)
				HandR.MoveTo(PiernasX + 44, PiernasY + 128)
				HandR.Scale(1, 1)
			elseif cambio == "Tired-Angry" then
				Animation = "Angry"
				HandR.Set("Papyrus/Arms/Right Angry")
				BoneR.Set("Bullets/Bones/Right Bone")
				Head.Set("Papyrus/Head/Phase 2/Upseted")
				HandR.rotation = 0
				HandR.SetPivot(7/84, 68/74)
				HandR.MoveTo(PiernasX + 53, PiernasY + 133)
				HandR.Scale(1, 1)
			end
			diffX = nil
			diffY = nil
			diffrot = nil
			vel = 0
		end
	elseif Animation == "Tired" then
		vel = vel + 1
		if Arms then
			Arms.Remove()
			Arms = nil
			HandL.alpha = 1
			HandR.alpha = 1
			BoneL.alpha = 1
			BoneR.alpha = 1
			Detail.alpha = 1
		end
		Body.MoveTo(6, 119 + 4*math.cos(math.rad(360/270*vel)))
		HandR.MoveTo(PiernasX + 44, PiernasY + 124 + 4*math.cos(math.rad(360/270*vel)))
		BoneR.MoveTo(PiernasX + 40 + 72*math.cos(math.rad(HandR.rotation - 90)), PiernasY + 112 + 4*math.cos(math.rad(360/270*vel)) + 80*math.sin(math.rad(HandR.rotation - 90)))
		HandL.MoveTo(PiernasX - 45, PiernasY + 118 + 4*math.cos(math.rad(360/270*vel)))
		BoneL.rotation = -10 + 10*math.cos(math.rad(360/270*vel))
		BoneR.rotation = 280 + 10*math.cos(math.rad(360/270*vel))
		for i=1,#LegsParts do
			local sprite = LegsParts[i]
			sprite.MoveTo(Legs.x, Legs.y + sprite.GetVar("Y"))
		end
	elseif Animation == "Alocado" then
		vel = vel + velanim
		Body.MoveTo(-8 + 6*math.sin(math.rad(360/36*vel)), 124 + math.pow(math.sin(math.rad(360/36*vel)), 2)*4)
		if ((vel%144 > 88 and vel%144 <= 144) or vel%144 == 0) and vel > 0 then
			if not timerhead then
				timerhead = 0
			end
			timerhead = timerhead + velanim
			if timerhead%28 < 7 then
				Head.MoveTo(1 + 10 - 10*math.cos(math.rad(360/28*timerhead)), 47 - 2 + (math.cos(math.rad(360/28*timerhead))*math.cos(math.rad(360/28*timerhead)))*2)
				Head.rotation = -10 + 10*math.cos(math.rad(360/28*timerhead))
				SetHead("Normal 1")
			elseif timerhead%28 < 14 then
				Head.MoveTo(1 + 10 + 10*math.cos(math.rad(360/28*timerhead)), 47 - 2 + (math.cos(math.rad(360/28*timerhead))*math.cos(math.rad(360/28*timerhead)))*2)
				Head.rotation = -10 - 10*math.cos(math.rad(360/28*timerhead))
				SetHead("Normal 3")
			elseif timerhead%28 < 21 then
				Head.MoveTo(1 - 10 - 10*math.cos(math.rad(360/28*timerhead)), 47 - 2 + (math.cos(math.rad(360/28*timerhead))*math.cos(math.rad(360/28*timerhead)))*2)
				Head.rotation = 10 + 10*math.cos(math.rad(360/28*timerhead))
				SetHead("Normal 1")
			else
				Head.MoveTo(1 - 10 + 10*math.cos(math.rad(360/28*timerhead)), 47 - 2 + (math.cos(math.rad(360/28*timerhead))*math.cos(math.rad(360/328*timerhead)))*2)
				Head.rotation = 10 - 10*math.cos(math.rad(360/28*timerhead))
				SetHead("Normal 2")
			end
		else
			timerhead = nil
		end
		HandL.rotation = -8*math.sin(math.rad(360/36*vel))
		HandL.MoveTo(Body.absx - 44, Body.absy - 13)
		HandR.MoveTo(Body.absx + 43, Body.absy - 3)
		for i=1,#LegsParts do
			local sprite = LegsParts[i]
			sprite.MoveTo(PiernasX + sprite.GetVar("intensity")*math.sin(math.rad(360/36*vel)), PiernasY + sprite.GetVar("Y"))
		end
	elseif Animation == "Cambio-Alocado" or Animation == "Cambio-Calmado" or Animation == "Cambio-Parar" then
		vel = vel + 1
		if vel <= 10 then
			if vel <= 1 then
				local headrot = Head.rotation
				local Variable = HandL.rotation
				if headrot > 10 then
					headrot = headrot - 360
				end
				if Variable > 20 then
					Variable = Variable - 360
				end
				Diff = {Legs = (PiernasX - LegsParts[51].x)/10, Body = {X = (-8 - Body.x)/10, Y = (124 - Body.y)/10}, Head = {X = (1 - Head.x)/10, Y = (47 - Head.y)/10}, RotHand = Variable/10, RotHead = -headrot/10}
			end
			Body.MoveTo(-8 - Diff.Body.X*(10 - vel), 124 - Diff.Body.Y*(10 - vel))
			Head.MoveTo(1 - Diff.Head.X*(10 - vel), 47 - Diff.Head.Y*(10 - vel))
			Head.rotation = -Diff.RotHead*(10 - vel)
			HandL.rotation = Diff.RotHand*(10 - vel)
			HandL.MoveTo(Body.absx - 44, Body.absy - 13)
			HandR.MoveTo(Body.absx + 43, Body.absy - 3)
			for i=2,#LegsParts do
				local sprite = LegsParts[i]
				sprite.MoveTo(PiernasX - Diff.Legs/50*i*(10 - vel), PiernasY + sprite.GetVar("Y"))
			end
		elseif Animation == "Cambio-Parar" then
			Animation = "None Phase 3"
			vel = 0
		elseif Animation == "Cambio-Calmado" then
			Animation = "Calmado"
			vel = 0
		elseif Animation == "Cambio-Alocado" then
			Animation = "Alocado"
			vel = 0
		end
	elseif Animation == "Calmado" then
		vel = vel + 1
		Body.MoveTo(-8, 124 - 2*math.sin(math.rad(360/90*vel)))
		HandL.rotation = -8*math.sin(math.rad(360/90*vel))
		HandL.MoveTo(Body.absx - 44, Body.absy - 13)
		HandR.MoveTo(Body.absx + 43, Body.absy - 3)
		for i=1,#LegsParts do
			local sprite = LegsParts[i]
			sprite.MoveTo(PiernasX, PiernasY + sprite.GetVar("Y"))
		end
	elseif Animation == "Hurt" then
		vel = vel + 1
		if vel == 1 then
			for i=1,3 do
				Audio.PlaySound("damage")
			end
			Legs.MoveTo(Legs.x + 10, Legs.y)
		elseif vel == 76 then
			Legs.MoveTo(Legs.x - 10, Legs.y)
			ResetAnim()
		elseif vel%30 == 1 then
			Legs.MoveTo(Legs.x + 20, Legs.y)
		elseif vel%30 == 16 then
			Legs.MoveTo(Legs.x - 20, Legs.y)
		end
		Body.MoveTo(-8, 124)
		Head.MoveTo(1, 47)
		Head.rotation = 0
		HandL.rotation = 0
		HandL.MoveTo(Body.absx - 44, Body.absy - 13)
		HandR.MoveTo(Body.absx + 43, Body.absy - 3)
		for i=1,#LegsParts do
			local sprite = LegsParts[i]
			sprite.MoveTo(Legs.x, PiernasY + sprite.GetVar("Y"))
		end
	elseif Animation == "None Phase 3" and phase == 3 and not ignore then
		HandL.MoveTo(Body.absx - 44, Body.absy - 13)
		HandR.MoveTo(Body.absx + 43, Body.absy - 3)
	elseif Animation == "Phase 4" then
		vel = vel + 1
		Body.MoveTo(3, 75 + 2*math.cos(math.rad(90/7*vel)))
		HandL.MoveTo(285, 368 + 2*math.cos(math.rad(90/7*vel)))
		HandR.MoveTo(357, 366 + 2*math.cos(math.rad(90/7*vel)))
	elseif Animation == "Stop Phase 4" then
		vel = vel + 1
		if vel == 1 then
			Diff = {Body = 75 - Body.y, HandL = 368 - HandL.y, HandR = 368 - HandR.y}
		end
		Body.MoveTo(3, 75 - Diff.Body/10*(10 - vel))
		HandL.MoveTo(285, 368 - Diff.HandL/10*(10 - vel))
		HandR.MoveTo(357, 368 - Diff.HandR/10*(10 - vel))
		if vel >= 10 then
			Animation = "None"
		end
	elseif Animation == "WAIT!" then
		vel = vel + 1
		if vel == 1 and not Done then
			SetHead("WAIT!")
			Jaw.MoveTo(Head.x, Head.y - 24)
			if GetAlMightyGlobal("Idioma") == "Spanish" then
				Bubble("[noskip][font:papyrus][voice:papyrus][waittall:0.5]ESPERA!!![w:100000000] ", "rightwide", 483.5, 381, 40, 90, 1)
			elseif GetAlMightyGlobal("Idioma") == "Russian" then
				Bubble("[noskip][font:papyrus][voice:papyrus][waittall:0.5]ПОСТОЙ!!![w:100000000] ", "rightwide", 483.5, 381, 40, 90, 1)	
			else
				Bubble("[noskip][font:papyrus][voice:papyrus][waittall:0.5]WAIT!!![w:100000000] ", "rightwide", 483.5, 381, 40, 90, 1)
			end
		end
		HandL.rotation = -20*math.sin(math.rad(90/20*vel))
		HandR.rotation = 20*math.sin(math.rad(90/20*vel))
		HandR.MoveTo(357 + 6*math.sin(math.rad(90/20*vel)), 370 - 2*math.cos(math.rad(90/20*vel)))
		if vel >= 20 then
			Animation = "None"
		end
	elseif Animation == "Reset Phase 4" then
		vel = vel + 1
		HandL.rotation = -20*math.cos(math.rad(90/20*vel))
		HandR.rotation = 20*math.cos(math.rad(90/20*vel))
		HandR.MoveTo(357 + 6*math.cos(math.rad(90/20*vel)), 370 - 2*math.sin(math.rad(90/20*vel)))
		if vel >= 20 then
			Animation = "None"
		end
	elseif Animation == "Death 1" then
		vel = vel + 1
		if vel <= 60 then
			if vel == 1 then
				HandL.alpha = 0
				HandR.alpha = 0
				SetHead("Power")
				Jaw.MoveTo(Head.x, Head.y - 20)
				Body.Set("Papyrus/Body/OUCH!")
				Misc.ShakeScreen(30, 20, true)
				Audio.PlaySound("heavydamage")
				if Bubbles[1] then
					Bubble("", "", 0, 0, 0, 0, 1)
				end
			end
			PapsMoveTo(322 + (30 - 5*vel/10)*math.sin(math.rad(360/10*vel)), 289)
		elseif vel > 60 and vel <= 150 then
			if vel == 61 then
				HandL.alpha = 1
				HandR.alpha = 1
				HandL.rotation = 0
				HandR.rotation = 0
				HandR.MoveTo(357, 368)
				Glow.Remove()
				Head.Remove()
				Jaw.Remove()
				Glow = nil
				Jaw = CreateSprite("Papyrus/Jaw", "Top")
				Head = CreateSprite("Papyrus/Head/Phase 4/Well", "Top")
				Body.Set("Papyrus/Body/My style")
			end
			Head.MoveTo(328 + 44*math.sin(math.rad(90/90*(vel - 60))), 333 + 90*math.cos(math.rad(90/90*(vel - 60))))
			Jaw.MoveTo(Head.x, Head.y - 20)
		elseif vel > 150 then
			Animation = "None"
		end
	elseif Animation == "Death 2" then
		vel = vel + 1
		if vel <= 40 then
			if vel == 1 then
				HandL.alpha = 0
				HandR.alpha = 0
				SetHead("Power")
				Body.Set("Papyrus/Body/OUCH!")
				for i=1,3 do
					Audio.PlaySound("damage")
				end
			end
			PapsMoveTo(322 + (30 - 7.5*vel/10)*math.sin(math.rad(360/10*vel)), 289)
			Head.MoveTo(372 + (30 - 7.5*vel/10)*math.sin(math.rad(360/10*vel)), 333)
			Jaw.MoveTo(Head.x, Head.y - 20)
		elseif vel > 40 and vel <= 80 then
			if vel == 41 then
				HandL.Remove()
				HandR.Remove()
				HandL = nil
				HandR = nil
				Body.Dust(true)
				Legs.Dust(true)
				Body = nil
				Legs = nil
				SetHead("Believe")
				Going = true
			end
			Head.MoveTo(372, 333 - 55/40*(vel - 40))
			Jaw.MoveTo(Head.x, Head.y - 24)
		elseif vel > 80 then
			Animation = "None"
		end
	elseif Animation == "Death 3" then
		vel = vel + 1
		if vel <= 40 then
			if vel == 1 then
				SetHead("Dying 1")
				Jaw.Set("Papyrus/Jaw Dying 1")
				for i=1,3 do
					Audio.PlaySound("damage")
				end
			end
			Head.MoveTo(372 + (30 - 7.5*vel/10)*math.sin(math.rad(360/10*vel)), 278)
			Jaw.MoveTo(Head.x, Head.y - 24)
		elseif vel > 40 then
			Animation = "None"
		end
	elseif Animation == "Death 4" then
		vel = vel + 1
		if vel <= 40 then
			if vel == 1 then
				SetHead("Dying 2")
				for i=1,3 do
					Audio.PlaySound("damage")
				end
			end
			Head.MoveTo(372 + (30 - 7.5*vel/10)*math.sin(math.rad(360/10*vel)), 278)
			Jaw.MoveTo(Head.x, Head.y - 24)
		elseif vel > 40 then
			Animation = "None"
		end
	elseif Animation == "Death 5" then
		vel = vel + 1
		if vel <= 40 then
			if vel == 1 then
				SetHead("Dying 3")
				Jaw.Set("Papyrus/Jaw Dying 2")
				for i=1,3 do
					Audio.PlaySound("damage")
				end
			end
			Head.MoveTo(372 + (30 - 7.5*vel/10)*math.sin(math.rad(360/10*vel)), 278)
			Jaw.MoveTo(Head.x, Head.y - 24)
		elseif vel > 40 then
			Animation = "None"
		end
	elseif Animation == "Death 6" then
		vel = vel + 1
		if vel == 1 then
			Jaw.Dust(true)
			Head.Dust(true)
			Jaw = nil
			Head = nil
			for i=1,3 do
				Audio.PlaySound("damage")
			end
			Animation = "None"
		end
	end
	if Sans.Animation == "Normal" then
		Sans.Timer = Sans.Timer + 1
		if not finished then
			Sans.Body.Set("Sans/Body/Left")
		end
		finished = true
		if Sans.Direction == 1 then
			Sans.Body.MoveTo(-1 - 1*math.cos(math.rad(180/20*Sans.Timer)), 48 + 1*math.sin(math.rad(180/20*Sans.Timer)))
			Sans.Head.MoveTo(0.5 - 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		else
			Sans.Body.MoveTo(-3 + 1*math.cos(math.rad(180/20*Sans.Timer)), 48 + 1*math.sin(math.rad(180/20*Sans.Timer)))
			Sans.Head.MoveTo(-0.5 + 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		end
		if Sans.Timer%80 == 40 then
			Sans.Direction = 2
		elseif Sans.Timer%80 == 0 then
			Sans.Direction = 1
		end
	elseif Sans.Animation == "Down" then
		Sans.Timer = Sans.Timer + 1
		Sans.Timer2 = Sans.Timer2 + 1
		finished = nil
		if Sans.Timer2 <= 9 then
			if Sans.Timer2 <= 3 then
				Sans.Body.Set("Sans/Body/Up")
			elseif Sans.Timer2 <= 6 then
				Sans.Body.Set("Sans/Body/Up-Down")
			else
				Sans.Body.Set("Sans/Body/Down")
			end
			Sans.Body.MoveTo(-2, 48 + 4*math.sin(math.rad(270/9*Sans.Timer2)))
		else
			Sans.Body.Set("Sans/Body/Down")
			Sans.Body.MoveTo(-2, 44)
		end
		if Sans.Direction == 1 then
			Sans.Head.MoveTo(0.5 - 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		else
			Sans.Head.MoveTo(-0.5 + 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		end
		if Sans.Timer%80 == 40 then
			Sans.Direction = 2
		elseif Sans.Timer%80 == 0 then
			Sans.Direction = 1
		end
	elseif Sans.Animation == "Up" then
		Sans.Timer = Sans.Timer + 1
		Sans.Timer2 = Sans.Timer2 + 1
		finished = nil
		if Sans.Timer2 <= 12 then
			if Sans.Timer2 <= 3 then
				Sans.Body.Set("Sans/Body/Down")
			elseif Sans.Timer2 <= 6 then
				Sans.Body.Set("Sans/Body/Up-Down")
			else
				Sans.Body.Set("Sans/Body/Up")
			end
			Sans.Body.MoveTo(-2, 48 - 4*math.sin(math.rad(360/12*Sans.Timer2)))
		else
			Sans.Body.Set("Sans/Body/Up")
			Sans.Body.MoveTo(-2, 48)
		end
		if Sans.Direction == 1 then
			Sans.Head.MoveTo(0.5 - 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		else
			Sans.Head.MoveTo(-0.5 + 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		end
		if Sans.Timer%80 == 40 then
			Sans.Direction = 2
		elseif Sans.Timer%80 == 0 then
			Sans.Direction = 1
		end
	elseif Sans.Animation == "Right" then
		Sans.Timer = Sans.Timer + 1
		Sans.Timer2 = Sans.Timer2 + 1
		finished = nil
		if Sans.Timer2 <= 12 then
			if Sans.Timer2 <= 3 then
				Sans.Body.Set("Sans/Body/Left")
			elseif Sans.Timer2 <= 6 then
				Sans.Body.Set("Sans/Body/Left-Right")
			else
				Sans.Body.Set("Sans/Body/Right")
			end
			Sans.Body.MoveTo(-2 - 4*math.sin(math.rad(360/12*Sans.Timer2)), 48)
		else
			Sans.Body.Set("Sans/Body/Right")
			Sans.Body.MoveTo(-2, 48)
		end
		if Sans.Direction == 1 then
			Sans.Head.MoveTo(0.5 - 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		else
			Sans.Head.MoveTo(-0.5 + 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		end
		if Sans.Timer%80 == 40 then
			Sans.Direction = 2
		elseif Sans.Timer%80 == 0 then
			Sans.Direction = 1
		end
	elseif Sans.Animation == "Left" then
		Sans.Timer = Sans.Timer + 1
		Sans.Timer2 = Sans.Timer2 + 1
		finished = nil
		if Sans.Timer2 <= 12 then
			if Sans.Timer2 <= 3 then
				Sans.Body.Set("Sans/Body/Right")
			elseif Sans.Timer2 <= 6 then
				Sans.Body.Set("Sans/Body/Left-Right")
			else
				Sans.Body.Set("Sans/Body/Left")
			end
			Sans.Body.MoveTo(-2 + 4*math.sin(math.rad(360/12*Sans.Timer2)), 48)
		else
			Sans.Body.Set("Sans/Body/Left")
			Sans.Body.MoveTo(-2, 48)
		end
		if Sans.Direction == 1 then
			Sans.Head.MoveTo(0.5 - 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		else
			Sans.Head.MoveTo(-0.5 + 0.5*math.cos(math.rad(180/20*Sans.Timer)), 43 + 1*math.sin(math.rad(180/20*Sans.Timer)))
		end
		if Sans.Timer%80 == 40 then
			Sans.Direction = 2
		elseif Sans.Timer%80 == 0 then
			Sans.Direction = 1
		end
	elseif Sans.Animation == "Death" then
		Sans.Timer = Sans.Timer + 1
		if Sans.Timer <= 60 then
			Sans.Legs.MoveTo(410 + (30 - 5*Sans.Timer/10)*math.sin(math.rad(360/10*Sans.Timer)), 255)
		else
			if string.sub(GetAlMightyGlobal("Archivimentazo"), 25, 25) == "0" then
				SetAlMightyGlobal("Archivimentazo", string.sub(GetAlMightyGlobal("Archivimentazo"), 1, 24).."1"..string.sub(GetAlMightyGlobal("Archivimentazo"), 26))
				LogroDesbloqueado = {Timer = 0, Icon = 25}
			end
			Sans.Animation = "None"
			Sans.Timer = 0
		end
	elseif Sans.Animation == "Stop" then
		Sans.Direction = 1
		Sans.Timer = Sans.Timer + 1
		finished = nil
		if Sans.Timer == 1 then
			DiffS = {Body = {X = -2 - Sans.Body.x, Y = 48 - Sans.Body.y}, Head = {X = -Sans.Head.x, Y = 43 - Sans.Head.y}}
		end
		Sans.Body.MoveTo(-2 - DiffS.Body.X/10*(10 - Sans.Timer), 48 - DiffS.Body.Y/10*(10 - Sans.Timer))
		Sans.Head.MoveTo(-DiffS.Head.X/10*(10 - Sans.Timer), 43 - DiffS.Head.Y/10*(10 - Sans.Timer))
		if Sans.Timer == 10 then
			Sans.Animation = "None"
			Sans.Timer = 0
		end
	end
	if Sans.Dodge then
		Sans.Dodge = Sans.Dodge + 1
		if Sans.Dodge <= 15 then
			Sans.Legs.MoveTo(410 + 100*math.sin(math.rad(90/15*Sans.Dodge)), 261)
		elseif Sans.Dodge == 40 then
			Wink()
		elseif Sans.Dodge > 100 then
			Sans.Legs.MoveTo(410 + 100*math.cos(math.rad(90/15*(Sans.Dodge - 100))), 261)
			if Sans.Dodge >= 115 then
				Sans.Dodge = nil
				Sans.Legs.MoveTo(410, 261)
			end
		end
	end
	if Sans.Wink then
		Sans.Wink = Sans.Wink + 1
		if Sans.Wink >= 30 then
			SetSansHead("Normal")
			Sans.Wink = nil
		end
	end
	if EggDog.Animation == "Normal 1" then
		EggDog.Timer = EggDog.Timer + 1
		EggDog.Head.MoveTo(-4*math.sin(math.rad(360/30*EggDog.Timer)), 20 - 4*math.cos(math.rad(360/30*EggDog.Timer)))
		EggDog.Neck.yscale = math.sqrt(math.pow(-4*math.sin(math.rad(360/30*EggDog.Timer)), 2) + math.pow(20 - 4*math.cos(math.rad(360/30*EggDog.Timer)), 2))
		EggDog.Neck.rotation = -math.atan2(EggDog.Head.x, EggDog.Head.y)/math.pi*180
		EggDog.Neck.MoveTo(EggDog.Body.x + EggDog.Head.x/2, EggDog.Body.y + EggDog.Head.y/2)
	elseif EggDog.Animation == "Normal 2" then
		EggDog.Timer = EggDog.Timer + 1
		if EggDog.Timer <= 15 then
			EggDog.Head.MoveTo(0, 16 + 3*EggDog.Timer)
		elseif EggDog.Timer > 30 and EggDog.Timer <= 45 then
			EggDog.Head.MoveTo(0, 61 - 3*(EggDog.Timer - 30))
		elseif EggDog.Timer >= 60 then
			EggDog.Timer = 0
		end
		EggDog.Neck.yscale = EggDog.Head.y
		EggDog.Neck.MoveTo(EggDog.Body.x, EggDog.Body.y + EggDog.Head.y/2)
	elseif EggDog.Animation == "Hurt" or EggDog.Animation == "Dead" then
		EggDog.Timer = EggDog.Timer + 1
		if EggDog.Timer == 1 then
			for i=1,3 do
				Audio.PlaySound("damage")
			end
			EggDog.Head.Set("Egg Dog/Ouch")
			EggDog.Neck.Scale(76, 26)
			EggDog.Neck.MoveTo(320, 303)
			EggDog.Neck.rotation = 0
			EggDog.Head.MoveTo(0, 16)
			EggDog.Body.x = EggDog.Body.x + 10
			EggDog.Neck.x = EggDog.Neck.x + 10
		elseif EggDog.Timer == 76 then
			EggDog.Body.x = EggDog.Body.x - 10
			EggDog.Neck.x = EggDog.Neck.x - 10
			EggDog.Timer = 0
			if EggDog.Animation == "Dead" then
				EggDog.Neck.Remove()
				EggDog.Head.Remove()
				EggDog.Body.Remove()
				Death = CreateSprite("Egg Dog/Death")
				Death.MoveTo(320, 292)
				Death.Dust(true)
				Death = nil
				EggDog = {Animation = "None", Timer = 0}
				NewAudio.Stop("Loop")
				nextwaves = {"You Win"}
				State("DEFENDING")
			else
				EggDog.Head.Set("Egg Dog/Head")
				EggDog.Animation = "Normal "..math.random(2)
			end
		elseif EggDog.Timer%30 == 1 then
			EggDog.Body.x = EggDog.Body.x + 20
			EggDog.Neck.x = EggDog.Neck.x + 20
		elseif EggDog.Timer%30 == 16 then
			EggDog.Body.x = EggDog.Body.x - 20
			EggDog.Neck.x = EggDog.Neck.x - 20
		end
	end
	if SpaghettiDies and Spaghetti then
		SpaghettiDies = SpaghettiDies + 1
		if SpaghettiDies <= 30 then
			if not Spaghetti.GetVar("Diff") then
				Spaghetti.SetVar("Diff", {X = 240 - Spaghetti.GetVar("Position").X, Y = 250 - Spaghetti.GetVar("Position").Y})
			end
			Spaghetti.MoveTo(Spaghetti.GetVar("Position").X + Spaghetti.GetVar("Diff").X*math.sin(math.rad(90/30*SpaghettiDies)), Spaghetti.GetVar("Position").Y + Spaghetti.GetVar("Diff").Y - Spaghetti.GetVar("Diff").Y*math.cos(math.rad(90/30*SpaghettiDies)))
			Spaghetti.rotation = 180/30*SpaghettiDies
		elseif SpaghettiDies == 31 and string.sub(GetAlMightyGlobal("Archivimentazo"), 23, 23) == "0" then
			SetAlMightyGlobal("Archivimentazo", string.sub(GetAlMightyGlobal("Archivimentazo"), 1, 22).."1"..string.sub(GetAlMightyGlobal("Archivimentazo"), 24))
			LogroDesbloqueado = {Timer = 0, Icon = 23}
		elseif SpaghettiDies > 120 and SpaghettiDies <= 180 then
			Spaghetti.alpha = 1/60*(180 - SpaghettiDies)
		elseif SpaghettiDies > 180 then
			SpaghettiDies = nil
			Spaghetti.Remove()
			Spaghetti = nil
		end
	end
	if FallBones and not summon then
		if not Vels then
			Vels = {0, 0}
			Times = {0, 0}
			local Rotation = BoneL.rotation + 90
			local Posiciones = {BoneL.absx, BoneL.absy}
			BoneL.Remove()
			BoneL = CreateSprite("Bullets/Bones/Left Bone","Top")
			BoneL.MoveTo(Posiciones[1], Posiciones[2])
			BoneL.rotation = Rotation
			BoneR.SetPivot(0.5, 0.5)
			BoneR.MoveTo(342 - 54*math.cos(math.rad(BoneR.rotation)) - 53*math.sin(math.rad(BoneR.rotation)), 241 + 53*math.cos(math.rad(BoneR.rotation)) - 54*math.sin(math.rad(BoneR.rotation)))
			AuxY = 241
			AuxY2 = 253
		end
		if Times[1] == 0 then
			Vels[1] = Vels[1] - 0.4
			AuxY = AuxY + Vels[1]
			BoneR.MoveTo(342 - 54*math.cos(math.rad(BoneR.rotation)) - 53*math.sin(math.rad(BoneR.rotation)), AuxY + 53*math.cos(math.rad(BoneR.rotation)) - 54*math.sin(math.rad(BoneR.rotation)))
			if AuxY <= 237 then
				AuxY = 237
				BoneR.MoveTo(342 - 54*math.cos(math.rad(BoneR.rotation)) - 53*math.sin(math.rad(BoneR.rotation)), AuxY + 53*math.cos(math.rad(BoneR.rotation)) - 54*math.sin(math.rad(BoneR.rotation)))
				Vels[1] = 4
				Times[1] = 1
				Rotacion = BoneR.rotation - 360
			end
		elseif Times[1] == 1 then
			Vels[1] = Vels[1] - 0.4
			Rotacion = math.max(Rotacion - 3, -135)
			AuxY = AuxY + Vels[1]
			BoneR.rotation = Rotacion
			BoneR.MoveTo(342 - 54*math.cos(math.rad(BoneR.rotation)) - 53*math.sin(math.rad(BoneR.rotation)), AuxY + 53*math.cos(math.rad(BoneR.rotation)) - 54*math.sin(math.rad(BoneR.rotation)))
			if AuxY <= 237 then
				AuxY = 237
				BoneR.MoveTo(342 - 54*math.cos(math.rad(BoneR.rotation)) - 53*math.sin(math.rad(BoneR.rotation)), AuxY + 53*math.cos(math.rad(BoneR.rotation)) - 54*math.sin(math.rad(BoneR.rotation)))
				BoneR.rotation = -135
				Rotacion = nil
				Vels[1] = 2
				Times[1] = 2
			end
		elseif Times[1] == 2 then
			Vels[1] = Vels[1] - 0.4
			AuxY = AuxY + Vels[1]
			BoneR.MoveTo(342 - 54*math.cos(math.rad(BoneR.rotation)) - 53*math.sin(math.rad(BoneR.rotation)), AuxY + 53*math.cos(math.rad(BoneR.rotation)) - 54*math.sin(math.rad(BoneR.rotation)))
			if BoneR.absy <= 237 then
				AuxY = 237
				BoneR.MoveTo(342 - 54*math.cos(math.rad(BoneR.rotation)) - 53*math.sin(math.rad(BoneR.rotation)), AuxY + 53*math.cos(math.rad(BoneR.rotation)) - 54*math.sin(math.rad(BoneR.rotation)))
				Times[1] = 3
			end
		end
		if Times[2] == 0 then
			Vels[2] = Vels[2] - 0.4
			AuxY2 = AuxY2 + Vels[2]
			BoneL.MoveTo(180 + 54*math.cos(math.rad(BoneL.rotation)) + 53*math.sin(math.rad(BoneL.rotation)), AuxY2 + 53*math.cos(math.rad(BoneL.rotation)) + 54*math.sin(math.rad(BoneL.rotation)))
			if AuxY2 <= 241 then
				AuxY2 = 241
				BoneL.MoveTo(180 + 54*math.cos(math.rad(BoneL.rotation)) + 53*math.sin(math.rad(BoneL.rotation)), AuxY2 + 53*math.cos(math.rad(BoneL.rotation)) + 54*math.sin(math.rad(BoneL.rotation)))
				Vels[2] = 4
				Times[2] = 1
			end
		elseif Times[2] == 1 then
			Vels[2] = Vels[2] - 0.4
			AuxY2 = AuxY2 + Vels[2]
			BoneL.rotation = math.min(BoneL.rotation + 3, 135)
			BoneL.MoveTo(180 + 54*math.cos(math.rad(BoneL.rotation)) + 53*math.sin(math.rad(BoneL.rotation)), AuxY2 + 53*math.cos(math.rad(BoneL.rotation)) + 54*math.sin(math.rad(BoneL.rotation)))
			if AuxY2 <= 241 then
				AuxY2 = 241
				BoneL.MoveTo(180 + 54*math.cos(math.rad(BoneL.rotation)) + 53*math.sin(math.rad(BoneL.rotation)), AuxY2 + 53*math.cos(math.rad(BoneL.rotation)) + 54*math.sin(math.rad(BoneL.rotation)))
				BoneL.rotation = 135
				Vels[2] = 2
				Times[2] = 2
			end
		elseif Times[2] == 2 then
			Vels[2] = Vels[2] - 0.4
			AuxY2 = AuxY2 + Vels[2]
			BoneL.MoveTo(180 + 54*math.cos(math.rad(BoneL.rotation)) + 53*math.sin(math.rad(BoneL.rotation)), AuxY2 + 53*math.cos(math.rad(BoneL.rotation)) + 54*math.sin(math.rad(BoneL.rotation)))
			if AuxY2 <= 241 then
				AuxY2 = 241
				BoneL.MoveTo(180 + 54*math.cos(math.rad(BoneL.rotation)) + 53*math.sin(math.rad(BoneL.rotation)), AuxY2 + 53*math.cos(math.rad(BoneL.rotation)) + 54*math.sin(math.rad(BoneL.rotation)))
				Times[2] = 3
			end
		end
		if Times[1] >= 3 and Times[2] == 3 then
			Times[1] = Times[1] + 1
			if Times[1] >= 43 then
				BoneR.alpha = BoneR.alpha - 0.075
				BoneL.alpha = BoneL.alpha - 0.075
				if BoneR.alpha <= 0 then
					BoneL.Remove()
					BoneR.Remove()
					BoneL = nil
					BoneR = nil
					AuxY = nil
					AuxY2 = nil
					Times = nil
					Vels = nil
					FallBones = nil
				end
			end
		end
	end
	if Shadow then
		if Shadow.GetVar("animation") == 1 then
			Shadow.alpha = Shadow.alpha + 1/60
			if Shadow.alpha >= 1 then
				Shadow.SetVar("animation", 0)
			end
		elseif Shadow.GetVar("animation") == 2 then
			Shadow.SetVar("color", Shadow.GetVar("color") - 255/30)
			Shadow.color = {Shadow.GetVar("color")/255, Shadow.GetVar("color")/255, Shadow.GetVar("color")/255}
			if Shadow.GetVar("color") <= 0 then
				Shadow.SetVar("animation", 0)
			end
		elseif Shadow.GetVar("animation") == 3 then
			Shadow.alpha = Shadow.alpha - 1/60
			if Shadow.alpha <= 0.6 then
				Shadow.SetVar("animation", 0)
			end
		elseif Shadow.GetVar("animation") == 4 then
			Shadow.alpha = 1
			Brillo = CreateSprite("Papyrus/Brillo","Top")
			Brillo.MoveTo(314, 426)
			Brillo.SetVar("color", 255)
			Shadow.SetVar("animation", 0)
		end
	end
	if Brillo and not summon then
		if Brillo.GetVar("relentizado") then
			Brillo.SetVar("relentizado", Brillo.GetVar("relentizado") + 1)
			Brillo.alpha = 0.6*math.sin(math.rad(180/50*Brillo.GetVar("relentizado")))
			Brillo.Scale(Brillo.xscale + 1/80, Brillo.yscale + 1/80)
			Brillo.color = {1, 1, 0}
			if Brillo.GetVar("relentizado") > 50 then
				Brillo.Remove()
				Brillo = nil
			end
		else
			Brillo.alpha = Brillo.alpha - 0.05
			Brillo.Scale(Brillo.xscale + 1/10, Brillo.yscale + 1/10)
			Brillo.SetVar("color", Brillo.GetVar("color") - 255/20)
			Brillo.color = {1, 1, math.max(0, Brillo.GetVar("color")/255)}
			if Brillo.alpha <= 0 then
				Brillo.Remove()
				Brillo = nil
			end
		end
	end
	if AnimationHands then
		HandsTimer = HandsTimer + 1
		HR.rotation = RotInicialR + AnimationHands*math.sin(math.rad(3*HandsTimer))
		HL.rotation = RotInicialL - AnimationHands*math.sin(math.rad(3*HandsTimer))
		if HandsTimer >= 30 then
			AnimationHands = nil
			HandsTimer = 0
			if HR.rotation == HL.rotation then
				vel = 0
				StopAnim = nil
				Head.Set("Papyrus/Head/Phase 1/Why...")
				Head.MoveTo(4, 42)
				AnimationHead = nil
				HeadTimer = 0
				HR.Remove()
				HL.Remove()
				HR = nil
				HL = nil
			end
		end
	end
	if AnimationHead then
		HeadTimer = HeadTimer + 1
		Head.MoveTo(Head.x, PosInicial + AnimationHead*math.sin(math.rad(3*HeadTimer)))
		if HeadTimer >= 30 then
			AnimationHead = nil
			HeadTimer = 0
		end
	end
	if BoneAnimation then
		if not Bone then
			Bone = CreateSprite("Bullets/Bones/Long Bone","Top")
			Bone.SetVar("velfall", 2)
			Bone.SetVar("Bounce", 0)
			Bone.MoveTo(286, 386)
			Bone.xscale = 1 + 10/286
			Bone.rotation = 46
		else
			Bone.MoveTo(173 + 148*math.cos(math.rad(Bone.rotation)), math.max(Bone.y - Bone.GetVar("velfall"), 240 + 148*math.sin(math.rad(Bone.rotation))))
			Bone.SetVar("velfall", Bone.GetVar("velfall") + 0.4)
			if Bone.GetVar("Bounce") >= 1 and Bone.GetVar("Bounce") <= 2 then
				if Bone.rotation > 3 then
					Bone.rotation = Bone.rotation - 1
				end
			end
			if math.max(Bone.y - Bone.GetVar("velfall"), 240 + 148*math.sin(math.rad(Bone.rotation))) == 240 + 148*math.sin(math.rad(Bone.rotation)) then
				if Bone.GetVar("Bounce") == 0 then
					Bone.SetVar("velfall", -5)
					Bone.SetVar("Bounce", Bone.GetVar("Bounce") + 1)
				elseif Bone.GetVar("Bounce") == 1 then
					Bone.SetVar("velfall", -3)
					Bone.SetVar("Bounce", Bone.GetVar("Bounce") + 1)
				elseif Bone.GetVar("Bounce") == 3 then
					Bone.SetVar("velfall", -1)
					Bone.SetVar("Bounce", Bone.GetVar("Bounce") + 1)
				elseif Bone.GetVar("Bounce") == 4 then
					Bone.Dust(true)
					Bone = nil
					BoneAnimation = nil
				end
			end
		end
	end
	if Count then
		Count = Count - 1
		if Count <= 0 then
			State("ENEMYDIALOGUE")
			Count = nil
		end
	end
	if Slice and not summon then
		if Slice.GetVar("random") == 1 then
			Slice.MoveTo(Slice.x - 8, Slice.y - 8)
			Slice.rotation = Slice.rotation + 1
		else
			Slice.MoveTo(Slice.x + 8, Slice.y - 8)
			Slice.rotation = Slice.rotation - 1
		end
		if Slice.absy < -40 then
			Slice.Remove()
			Slice = nil
		end
	end
	if Glow and not summon then
		if fadeGlow and Glow.alpha > 0 then
			Glow.alpha = Glow.alpha - 0.05
		elseif not fadeGlow then
			if Glow.alpha > GlowMax then
				Glow.alpha = Glow.alpha - 0.05
			elseif Glow.alpha < GlowMax then
				Glow.alpha = Glow.alpha + 0.05
			end
		end
		if GlowEffect then
			GlowEffect.Scale(GlowEffect.xscale + 1/5, GlowEffect.yscale + 1)
			GlowEffect.alpha = GlowEffect.alpha - 0.02
			if GlowEffect.alpha <= 0 then
				GlowEffect.Remove()
				GlowEffect = nil
			end
		elseif Glow.alpha >= 1 and GlowTimer <= 0 and not GlowEffect then
			GlowEffect = CreateSprite("Bullets/Bones/Body","Top")
			GlowEffect.color = {233/255, 156/255, 0}
			GlowEffect.Scale(8/5, 8)
			GlowEffect.SetParent(Head)
			GlowEffect.MoveTo(-10, 3)
			GlowTimer = 180
		elseif GlowTimer > 0 then
			GlowTimer = GlowTimer - 1
		end
	end
	if BoneItem then
		timeritem = timeritem + 1
		if timeritem >= 1 and timeritem < 26 then
			BoneItem.MoveTo(BoneItem.x - 780/25, 193)
			if BoneItem.x <= 320 then
				Text1.rotation = 5
				Text2.rotation = -3
				if BoneItem.x <= 261 then
					Text1.MoveTo(Text1.x - 780/25, 193)
					Text2.MoveTo(Text2.x - 780/25, 193)
				end
			end
		elseif timeritem == 26 then
			BoneItem.Remove()
			Text1.Remove()
			Text2.Remove()
			BoneItem = nil
			Text1 = nil
			Text2 = nil
			timeritem = nil
		end
	end
	if eventtimer then
		eventtimer = eventtimer + 1
		if eventtimer <= 30 then
			Ketchup.MoveTo(320 + 172/30*eventtimer, -60 + 386/30*eventtimer)
			Ketchup.Scale(3 - 2/30*eventtimer, 3 - 2/30*eventtimer)
			Ketchup.rotation = 360/30*(30 - eventtimer)
			if eventtimer == 24 then
				Sans.Animation = "Right"
				Sans.Timer2 = 0
			end
		else
			Audio.PlaySound("st")
			SetHead("Disgust")
			AttackAnim(1)
			eventtimer = nil
		end
	end
	if BLOCK then
		BLOCK.SetVar("ang", BLOCK.GetVar("ang") + 180/40)
		if BLOCK.GetVar("ang") <= 180 then
			BLOCK.MoveTo(320, 380 + 30*math.sin(math.rad(BLOCK.GetVar("ang"))))
		elseif BLOCK.GetVar("ang") >= 250 then
			BLOCK.Remove()
			BLOCK = nil
		end
	end
	if REPEL and not summon then
		REPEL.SetVar("ang", REPEL.GetVar("ang") + 180/40)
		if REPEL.GetVar("ang") <= 180 then
			REPEL.MoveTo(320, 380 + 30*math.sin(math.rad(REPEL.GetVar("ang"))))
		elseif REPEL.GetVar("ang") >= 250 then
			REPEL.Remove()
			REPEL = nil
		end
	end
	if GhostTimer then
		GhostTimer = GhostTimer + 1
		if GhostTimer <= 30 then
			Ghost.alpha = 0.25/30*GhostTimer
		elseif GhostTimer > 150 then
			Ghost.alpha = 0.25/30*(180 - GhostTimer)
			if GhostTimer >= 180 then
				Ghost.Remove()
				GhostTimer = nil
			end
		end
	end
	if summon then
		summon = nil
	end
end

function KillSans()
	SetSansHead("Surprised")
	Sans.Body.MoveTo(-2, 42)
	Sans.Head.MoveTo(0, 37)
	Sans.Legs.MoveTo(410, 255)
	Sans.Legs.Set("Sans/Legs Joking")
	Sans.Animation = "Death"
	Sans.Timer = 0
	Misc.ShakeScreen(30, 20, true)
	Audio.PlaySound("heavydamage")
	AttackAnim(1)
	NewAudio.Pause("Loop")
end

function Kick()
	Ketchup = CreateSprite("Sans/Ketchup","Top")
	Ketchup.Scale(2, 2)
	Ketchup.MoveTo(320, -60)
	eventtimer = 0
end

function PapyrusGhost()
	Ghost = CreateSprite("Papyrus/Ghost", "Top")
	Ghost.MoveTo(320, 344)
	Ghost.alpha = 0
	GhostTimer = 0
end

function InitiatePhase4(num)
	if num == 1 then
		phase = 4
		progress = 0
		BG1.Remove()
		BG2.Remove()
		BackgroundAnimation = nil
		Sans.Head.Remove()
		Sans.Body.Remove()
		Sans.Legs.Remove()
		Sans = {Animation = "None", Timer = 0, Timer2 = 0, Direction = 1}
		Undyne.Head.Remove()
		Undyne.Eye.Remove()
		Undyne.Hair.Remove()
		Undyne.Torso.Remove()
		Undyne.Dress.Remove()
		Undyne.Arms.Left.Remove()
		Undyne.Arms.Right.Remove()
		Undyne.Legs.Remove()
		Undyne = {Animation = "None", Timer = 0}
		HandL.MoveTo(285, 370)
		HandR.MoveTo(357, 368)
		for i=1,#LegsParts do
			LegsParts[i].Remove()
		end
		LegsParts = {}
		Legs.Set("Papyrus/Legs/Front")
		Body.Set("Papyrus/Body/My style")
		Head.MoveTo(3, 57)
		Jaw.MoveTo(Head.x, Head.y - 20)
		Body.MoveTo(3, 77)
		SetHead("nyeh...")
		PapsMoveTo(322, 289)
		Jaw.alpha = 1
		if GetAlMightyGlobal("Idioma") == "Spanish" then
			enemies[1]["commands"] = {"Checar"}
		elseif GetAlMightyGlobal("Idioma") == "Russian" then
			enemies[1]["commands"] = {"Проверить"}	
		else
			enemies[1]["commands"] = {"Check"}
		end
	elseif num == 2 then
		SetHead("Power")
		Body.Set("Papyrus/Body/OUCH!")
		HandL.alpha = 0
		HandR.alpha = 0
	elseif num == 3 then
		SetHead("NO!")
		Body.Set("Papyrus/Body/My style")
		HandL.alpha = 1
		HandR.alpha = 1
		vel = 0
		Animation = "Phase 4"
		Legs.layer = "BelowArena"
		HandL.layer = "BelowArena"
		HandR.layer = "BelowArena"
	end
end

function InitiatePhase3(num)
	if num == 1 then
		Animation = "None"
		if not BG1 then
			BG1 = CreateSprite("Specials/Background Lines","BelowArena")
			BG1.color = {0.25,0.25,0.25}
			BG1.yscale = 218/206
			BG1.MoveTo(320, 103*BG1.yscale)
		end
		if not BG2 then
			BG2 = CreateSprite("Specials/Background","BelowArena")
			BG2.color = {1/2, 150/255/2, 0}
			BG2.yscale = 223/206
			BG2.MoveTo(320, 103*BG2.yscale)
		end
		RelayerUI("BelowArena")
		SetHead("Start1")
		HandL.Set("Papyrus/Arms/Right Tired Inv")
		HandL.SetPivot(8/30, 111/118)
		HandL.rotation = 0
		HandL.MoveTo(286, Body.absy + 11)
		HandR.Set("Papyrus/Arms/Right Tired")
		HandR.SetPivot(22/30, 111/118)
		HandR.MoveTo(364, Body.absy + 5)
		for i=1,#LegsParts do
			LegsParts[i].layer = "Bottom"
			LegsParts[i].layer = "Top"
		end
		HandL.layer = "Bottom"
		HandR.layer = "Bottom"
		HandL.layer = "Top"
		HandR.layer = "Top"
		Legs.layer = "Bottom"
		Legs.layer = "Top"
		if Detail then
			Detail.Remove()
			Detail = nil
		end
		if BoneL and BoneR then
			BoneL.Remove()
			BoneR.Remove()
			BoneL = nil
			BoneR = nil
			AuxY = nil
			AuxY2 = nil
			Times = nil
			Vels = nil
			FallBones = nil
		end
	elseif num == 2 then
		SetHead("Start4")
		HandL.Set("Papyrus/Arms/Crying Left Hand")
		HandL.SetPivot(0, 0)
		HandL.rotation = 0
		HandL.layer = "Bottom"
		HandL.layer = "Top"
		HandL.MoveTo(274, Body.absy - 14)
		HandR.Set("Papyrus/Arms/Crying Right Hand")
		HandR.SetPivot(1, 0)
		HandR.rotation = 0
		HandR.layer = "Bottom"
		HandR.layer = "Top"
		HandR.MoveTo(378, Body.absy - 4)
	elseif num == 3 then
		HandL.MoveTo(274, Body.absy - 4)
		HandR.MoveTo(378, Body.absy + 6)
	elseif num == 4 then
		for i=1,#LegsParts do
			local sprite = LegsParts[i - tableaux]
			sprite.Remove()
			table.remove(LegsParts, i - tableaux)
			tableaux = tableaux + 1
		end
		tableaux = 0
		Jaw.alpha = 0
		SetHead("Ready")
		Body.Set("Papyrus/Body/BackBone")
		Legs.Set("Papyrus/Legs/Phase 3/0")
		Body.MoveTo(-3, 121)
		Head.MoveTo(-1, 51)
		HandL.MoveTo(273, Body.absy - 8)
		HandR.MoveTo(376, Body.absy + 1)
		for i=1,51 do
			Sprite = CreateSprite("Papyrus/Legs/Phase 3/"..i,"Top")
			Sprite.SetVar("X", (PiernasX or Legs.x))
			Sprite.SetVar("intensity", -6/50 + 6/50*i)
			if i > 1 then
				Sprite.MoveTo((PiernasX or Legs.x), (PiernasY or Legs.y) - 1 + 2*i)
				Sprite.SetVar("Y", -1 + 2*i)
			else
				Sprite.MoveTo((PiernasX or Legs.x), (PiernasY or Legs.y))
				Sprite.SetVar("Y", 0)
			end
			table.insert(LegsParts, Sprite)
		end
		Legs.layer = "Bottom"
		Legs.layer = "Top"
	elseif num == 5 then
		Legs.layer = "Top"
		Legs.layer = "Bottom"
		if not Sans.Legs then
			SpawnSans()
		end
		Sans.Legs.layer = "Top"
		Sans.Legs.layer = "Bottom"
		HandL.Set("Papyrus/Arms/CrusherL")
		HandR.Set("Papyrus/Arms/CrusherR")
		Body.MoveTo(-8, 124)
		Head.MoveTo(1, 47)
		HandL.SetPivot(33/36, 27/74)
		HandR.SetPivot(6/56, 69/72)
		HandL.MoveTo(276, Body.absy - 13)
		HandR.MoveTo(366, Body.absy - 3)
		Animation = "Alocado"
		Sans.Animation = "Normal"
		BackgroundAnimation = "Normal"
		BGY = -10
		vel = 0
		Sans.Timer = 0
		BackgroundTimer = 0
		Sans.Direction = 1
		SansAlpha(0.5)
		SetHead("Normal 1")
		SetSansHead("Normal")
	end
end

function Wink()
	SetSansHead("Wink")
	Sans.Wink = 0
end

function SansAlpha(number)
	Sans.Head.color = {number, number, number}
	Sans.Body.color = {number, number, number}
	Sans.Legs.color = {number, number, number}
end

function PapyrusAlpha(number)
	if Body then
		Body.color = {number, number, number}
	end
	if Head then
		Head.color = {number, number, number}
	end
	if HandR then
		HandR.color = {number, number, number}
	end
	if HandL then
		HandL.color = {number, number, number}
	end
	if Jaw then
		Jaw.color = {number, number, number}
	end
	if Legs then
		Legs.color = {number, number, number}
	end
	if LegsParts then
		for i=1,#LegsParts do
			LegsParts[i].color = {number, number, number}
		end
	end
end

function UndyneAlpha(number)
	Undyne.Legs.color = {number, number, number}
	Undyne.Dress.color = {number, number, number}
	Undyne.Torso.color = {number, number, number}
	Undyne.Arms.Left.color = {number, number, number}
	Undyne.Arms.Right.color = {number, number, number}
	Undyne.Head.color = {number, number, number}
	Undyne.Hair.color = {number, number, number}
	Undyne.Eye.color = {number, number, number}
end

function Betrayal()
	Audio.PlaySound("heavydamage")
	Misc.ShakeScreen(30, 20, false)
	Head.Set("Papyrus/Head/Phase 1/OUCH")
	Animation = "Betrayal"
	vel = 0
	if HR and HL then
		HR.Remove()
		HL.Remove()
		HR = CreateSprite("Papyrus/Arms/Death Right Hand","BelowUI")
		HL = CreateSprite("Papyrus/Arms/Death Left Hand","BelowUI")
		HR.MoveTo(391, 291)
		HL.MoveTo(246, 285)
	end
end

function ShowStatus(num)
	if num == 1 and Black3 then
		Black3.alpha = 0
	elseif num == 2 and Black4 then
		Black4.alpha = 0
	elseif num == 3 and Black5 then
		Black5.alpha = 0
	elseif num == 4 and Black6 then
		Black6.alpha = 0
	elseif num == 5 and Black3 and Black4 and Black5 and Black6 then
		Black3.alpha = 1
		Black4.alpha = 1
		Black5.alpha = 1
		Black6.alpha = 1
	end
end

function GlowAlpha(num)
	GlowMax = num
end

function AttackAnim(num)
	num = tonumber(num)
	if phase == 1 then
		if num == 1 then
			Legs.Set("Papyrus/Legs/Front")
			Body.Set("Papyrus/Body/Front")
			Head.Set("Papyrus/Head/Phase 1/Attacking")
			Body.MoveTo(0, 72)
			Head.MoveTo(4, 62)
			Jaw.MoveTo(Head.x, Head.y - 20)
			fadeGlow = true
			Animation = "None"
		elseif num == 2 then
			Legs.Set("Papyrus/Legs/Front")
			Body.Set("Papyrus/Body/Front Arm")
			Head.Set("Papyrus/Head/Phase 1/Attacking")
			Body.MoveTo(0, 39)
			Head.MoveTo(4, 95)
			Jaw.MoveTo(Head.x, Head.y - 20)
			Animation = "None"
		elseif num == 3 then
			Body.Set("Papyrus/Body/NO!")
			Head.Set("Papyrus/Head/Phase 1/Normal")
			Body.MoveTo(0, 71)
			Head.MoveTo(4, 62)
			Jaw.MoveTo(Head.x, Head.y - 24)
			Glow.alpha = 0
			fadeGlow = true
			Animation = "None"
		elseif num == 4 then
			Body.Set("Papyrus/Body/NO!")
			Head.Set("Papyrus/Head/Phase 1/Worried")
			Body.MoveTo(0, 71)
			Head.MoveTo(4, 62)
			Jaw.MoveTo(Head.x, Head.y - 20)
			Glow.alpha = 0
			fadeGlow = true
			Animation = "None"
		elseif num == 5 then
			Legs.Set("Papyrus/Legs/Front")
			Body.Set("Papyrus/Body/Disbelief")
			Head.Set("Papyrus/Head/Phase 1/Regretted")
			Body.MoveTo(0, 71)
			Head.MoveTo(4, 62)
			Jaw.MoveTo(Head.x, Head.y - 24)
			Glow.alpha = 0
			Body.alpha = 0
			fadeGlow = true
			Animation = "None"
			BodySeparated = true
			FalseBody = CreateSprite("Papyrus/Body/Disbelief","Top")
			FalseBody.MoveTo(Legs.x + Body.x, Legs.y + Body.y)
		end
	elseif phase == 2 then
		if num == 1 and Animation ~= "Angry" then
			Animation = "Transition"
			cambio = "Tired-Angry"
			vel = 0
		elseif num == 2 and Animation ~= "Tired" then
			Animation = "Transition"
			cambio = "Angry-Tired"
			vel = 0
		end
	elseif phase == 3 then
		if num == 1 then
			Animation = "Cambio-Parar"
			vel = 0
		elseif num == 2 then
			if Animation == "Alocado" then
				Animation = "Cambio-Calmado"
			else
				Animation = "Cambio-Alocado"
			end
			vel = 0
		elseif num == 3 and Animation ~= "Alocado" then
			Animation = "Alocado"
			vel = 0
		elseif num == 4 then
			SetHead("heh...")
			Animation = "None"
			Head.MoveTo(1, 43)
			HandL.Set("Papyrus/Arms/Left Tired 2")
			HandR.Set("Papyrus/Arms/Right Tired 2")
			HandL.SetPivot(0.5, 1)
			HandR.SetPivot(0.5, 1)
			HandL.MoveTo(284, 362)
			HandR.MoveTo(358, 366)
			HandL.rotation = 0
			HandR.rotation = 0
			HandL.SendToTop()
			HandR.SendToTop()
		end
	end
end

function SwingUndyne()
	if Undyne.Arms and Undyne.Arms.Left then
		Undyne.Arms.Left.SetVar("Timer", 0)
	end
end

function AnimateHands(num)
	if not HR and not HL then
		Head.Set("Papyrus/Head/Phase 1/WAAA~")
		HR = CreateSprite("Papyrus/Arms/Crying Right Hand","BelowUI")
		HL = CreateSprite("Papyrus/Arms/Crying Left Hand","BelowUI")
		Head.MoveTo(4, 60)
		HR.SetPivot(46/50, 4/70)
		HL.SetPivot(4/52, 4/74)
		HR.MoveTo(366, 326)
		HL.MoveTo(272, 322)
	end
	RotInicialL = HL.rotation
	RotInicialR = HR.rotation
	AnimationHands = RotInicialL - num
	HandsTimer = 0
	StopAnim = true
end

function AnimateHead(num)
	PosInicial = Head.y
	AnimationHead = num
	HeadTimer = 0
end

function SetHead(sprite)
	if phase ~= -1 then
		Head.Set("Papyrus/Head/Phase "..phase.."/"..sprite)
	else
		HeadTem.Set("Papyrus/Head/Phase -1/"..sprite)
	end
end

function SetSansHead(sprite)
	Sans.Head.Set("Sans/Head/"..sprite)
end

EggDog = {Animation = "None", Timer = 0}

function SpawnEggDog()
	EggDog.Neck = CreateSprite("Pixel","BelowArena")
	EggDog.Body = CreateSprite("Egg Dog/Body","BelowArena")
	EggDog.Head = CreateSprite("Egg Dog/Head","BelowArena")
	EggDog.Body.SetPivot(0.5, 56/84)
	EggDog.Head.SetPivot(0.5, 0)
	EggDog.Head.SetParent(EggDog.Body)
	EggDog.Neck.Scale(76, 26)
	EggDog.Body.MoveTo(320, 290)
	EggDog.Neck.MoveTo(320, 303)
	EggDog.Head.MoveTo(0, 16)
	EggDog.Animation = "Normal "..math.random(2)
end

function BlockAnim()
	if phase == 1 then
		if fadeGlow then
			fadeGlow = nil
		end
		Legs.Set("Papyrus/Legs/Front")
		Body.Set("Papyrus/Body/Front")
		Head.Set("Papyrus/Head/Phase 1/Blocking")
		Arms = CreateSprite("Papyrus/Arms/Block","Bottom")
		Arms.MoveTo(320, 360)
		vel = 0
		frecuencia = 0
		Body.MoveTo(0, 72)
		Head.MoveTo(4, 64)
		Legs.MoveTo(320, 285)
		Jaw.MoveTo(Head.x, Head.y - 24)
		Animation = "Block Phase 1"
		if BoneAnimation then
			BoneAnimation = nil
			Bone.Remove()
			Bone = nil
		end
		if HR and HL then
			HR.Remove()
			HL.Remove()
			HR = nil
			HL = nil
		end
	elseif phase == 2 then
		vel = -1
		frecuencia = 0
		AnimatePapyrus()
		Arms = CreateSprite("Papyrus/Arms/Blocking","Bottom")
		Arms.MoveTo(Legs.x + 4, Legs.y + 90)
		HandL.alpha = 0
		HandR.alpha = 0
		BoneL.alpha = 0
		BoneR.alpha = 0
		Detail.alpha = 0
		Animation = "Block Phase 2"
	elseif phase == 3 then
		vel = -1
		Before = Animation
		Animation = "Hurt"
		SetHead("Ready")
		AnimatePapyrus()
	end
end

function ResetAnim()
	if phase == -1 then
		Legs.MoveTo(320, 600)
		if not Papaya then
			Papaya = CreateSprite("Papyrus/Silla")
			HeadTem = CreateSprite("Papyrus/Head/Phase -1/Whatever")
			Papaya.MoveTo(320, 340)
			HeadTem.MoveTo(322, 418)
		end
	elseif phase == 1 then
		if Arms then
			Arms.Remove()
			Arms = nil
		end
		if fadeGlow then
			fadeGlow = nil
		end
		Legs.Set("Papyrus/Legs/Normal")
		Body.Set("Papyrus/Body/Disbelief")
		Head.Set("Papyrus/Head/Phase 1/Believe")
		Body.MoveTo(0, 70)
		Head.MoveTo(4, 62)
		Jaw.MoveTo(Head.x, Head.y - 21)
		vel = 0
		Animation = "Phase 1"
	elseif phase == 2 then
		if cambio and cambio == "Angry-Tired" then
			Animation = "Tired"
		else
			Animation = "Angry"
		end
		vel = -1
		AnimatePapyrus()
	elseif phase == 3 then
		Animation = Before
		vel = 0
		SetHead("Normal 1")
	end
end

function SetJaw(pos)
	Jaw.MoveTo(Head.x, Head.y - pos)
end

function Cry()
	Legs.Set("Papyrus/Legs/Given Up")
	Body.Set("Papyrus/Body/Suffering")
	Head.Set("Papyrus/Head/Phase 1/Why...")
	Body.MoveTo(-4, 51)
	Head.MoveTo(4, 42)
	if FUN[1] == "Rare" and FUN[2] == 1 then
		SuperCry = true
		vel = -400
	else
		vel = 0
	end
	Jaw.MoveTo(Head.x, Head.y - 2)
	Body.alpha = 1
	BodySeparated = nil
	FalseBody.Remove()
	FalseBody = nil
	Animation = "Crying"
	BoneAnimation = true
end

function PapsMoveTo(x, y)
	Legs.MoveTo(x, y)
	if PiernasX and PiernasY then
		PiernasX = x
		PiernasY = y
	end
	if BodySeparated then
		FalseBody.MoveTo(x, y + 71)
	end
	if phase == 2 or phase == 3 then
		vel = vel - 1
		frecuencia = math.max(frecuencia - 2, 0)
		if timerhead then
			timerhead = timerhead - 1
		end
		Sans.Timer = math.max(Sans.Timer - 1, 0)
		BackgroundTimer = math.max(BackgroundTimer - 1, 0)
		Undyne.Timer = math.max(Undyne.Timer - 1, 0)
		if Undyne.Arms and Undyne.Arms.Left and Undyne.Arms.Left.GetVar("Timer") then
			Undyne.Arms.Left.SetVar("Timer", math.max(Undyne.Arms.Left.GetVar("Timer") - 1, 0))
		end
		summon = true
		if Animation == "None Phase 3" then
			for i=1,#LegsParts do
				local sprite = LegsParts[i]
				sprite.MoveTo((PiernasX or x), (PiernasY or y) + sprite.GetVar("Y"))
			end
		end
		for i=1,#Squares do
			local Datos = Squares[i]
			Datos.Y = Datos.Y - 2
			Datos.Scale = Datos.Scale + 30/180
			Datos.Alpha = Datos.Alpha + 0.5/90
		end
		AnimatePapyrus()
	end
end

function AnimateRepel()
	Audio.PlaySound("damage")
	REPEL = CreateSprite("REPELED "..GetAlMightyGlobal("Idioma"))
	REPEL.Scale(0.4,0.4)
	REPEL.MoveTo(320, 380)
	REPEL.SetVar("ang", 0)
end

function AnimateBlock(breakbone)
	if not breakbone then
		Audio.PlaySound("damage")
		BLOCK = CreateSprite("BLOCKED "..GetAlMightyGlobal("Idioma"))
		BLOCK.Scale(0.4,0.4)
		BLOCK.MoveTo(320, 380)
		BLOCK.SetVar("ang", 0)
	else
		Animation = "Ouch"
		vel = 0
	end
end

function StartPhase2(num)
	if num == 1 then
		if Arms then
			Arms.Remove()
			Arms = nil
		end
		Legs.Set("Papyrus/Legs/Serious")
		Body.Set("Papyrus/Body/You little...")
		Head.Set("Papyrus/Head/Phase 2/ENOUGH!")
		Legs.MoveTo(240, 286)
		Body.MoveTo(0, 33)
		Head.MoveTo(0, 100)
		Jaw.MoveTo(Head.x, Head.y - 20)
	elseif num == 2 then
		Legs.Set("Papyrus/Legs/Begin")
		Body.Set("Papyrus/Body/You'll see")
		Head.Set("Papyrus/Head/Phase 2/GET READY!")
		Legs.MoveTo(320, 286)
		Body.MoveTo(4, 35)
		Head.MoveTo(2, 102)
		Jaw.MoveTo(Head.x, Head.y - 26)
	elseif num == 3 then
		Shadow = CreateSprite("Papyrus/Papyrus Shadow","Top")
		Shadow.SetParent(Legs)
		Shadow.MoveTo(4, 55)
		Shadow.SetVar("animation", 1)
		Shadow.SetVar("color", 255)
		Shadow.alpha = 0
	elseif num == 4 then
		if Black1 then
			Black1.Remove()
			Black1 = nil
		end
		if Black2 then
			Black2.Remove()
			Black2 = nil
		end
		if Black3 then
			Black3.Remove()
			Black3 = nil
		end
		if Black4 then
			Black4.Remove()
			Black4 = nil
		end
		if Black5 then
			Black5.Remove()
			Black5 = nil
		end
		if Black6 then
			Black6.Remove()
			Black6 = nil
		end
		if Shadow then
			Shadow.Remove()
			Shadow = nil
		end
		Legs.layer = "BelowUI"
		Legs.Set("Papyrus/Legs/Phase 2/0")
		Body.Set("Papyrus/Body/Angry")
		for i=1,40 do
			Sprite = CreateSprite("Papyrus/Legs/Phase 2/"..i,"Bottom")
			Sprite.SetVar("X", 320)
			Sprite.SetVar("intensity", -0.25 + 0.25*i)
			if i > 1 then
				Sprite.MoveTo(320, 240 - 1 + 2*i)
				Sprite.SetVar("Y", -1 + 2*i)
			else
				Sprite.MoveTo(320, 240)
				Sprite.SetVar("Y", 0)
			end
			table.insert(LegsParts, Sprite)
		end
		BoneL = CreateSprite("Bullets/Bones/Left Bone","Bottom")
		BoneR = CreateSprite("Bullets/Bones/Right Bone","Bottom")
		HandL = CreateSprite("Papyrus/Arms/Left Angry","Bottom")
		Detail = CreateSprite("Papyrus/Arms/Left Angry Detail","Bottom")
		HandR = CreateSprite("Papyrus/Arms/Right Angry","Bottom")
		if FUN[1] == "Epic" and FUN[2] == 2 then
			Spaghetti = CreateSprite("Papyrus/Spaghetti","Bottom")
			Spaghetti.SetParent(Head)
			Spaghetti.MoveTo(0, 22)
		end
		HandL.SetPivot(45/52, 7/56)
		HandR.SetPivot(7/84, 68/74)
		Detail.SetPivot(45/52, 7/56)
		BoneL.SetParent(HandL)
		Detail.SetParent(HandL)
		Legs.MoveTo(320, 240)
		Body.MoveTo(6, 123)
		Head.MoveTo(2, 65)
		Jaw.MoveTo(Head.x, Head.y - 26)
		HandL.MoveTo(275, 364)
		HandR.MoveTo(373, 373)
		Detail.MoveTo(19, -21)
		BoneL.MoveTo(-16, 14)
		BoneR.MoveTo(424, 316)
		PiernasX = 320
		PiernasY = 240
		Animation = "Angry"
		vel = 0
		Legs.layer = "Bottom"
		Player.SetAttackAnim({"UI/Battle/spr_slice_o_0","UI/Battle/spr_slice_o_1","UI/Battle/spr_slice_o_2","UI/Battle/spr_slice_o_3"}, 0.1)
		if GetAlMightyGlobal("Idioma") == "Spanish" then
			enemies[1]["commands"] = {"Checar", "Recoquetear", "Llorar", "Bromear"}
		elseif GetAlMightyGlobal("Idioma") == "Russian" then
		    enemies[1]["commands"] = {"Проверить", "Перефлирт", "Плакать", "Шутка"}
		else
			enemies[1]["commands"] = {"Check", "Reflirt", "Cry", "Pun"}
		end
	end
end

function SetHeadUndyne(sprite)
	Undyne.Head.Set("Undyne/Head/"..sprite)
end

function Laugh()
	laughtimer = 0
end

function AnimateShadow(num)
	if Shadow then
		Shadow.SetVar("animation", num)
	end
end

function SpawnText(type)
	if not type then
		Textitos = true
	else
		if GetAlMightyGlobal("Idioma") == "Spanish" then
			BattleDialog({"[noskip][effect:none][w:10]Oh.[w:10]\nSupongo que no te comiste el\r"..type.."."})
		elseif GetAlMightyGlobal("Idioma") == "Russian" then
			BattleDialog({"[noskip][effect:none][w:10]Oй.[w:10]\nПохоже, что вы не съели\r"..type.."."})
		else
			BattleDialog({"[noskip][effect:none][w:10]Oh.[w:10]\nI guess you didn't eat the\r"..type.."."})
		end
		State("DIALOGRESULT")
		Audio.PlaySound("throw")
		Text1 = CreateSprite("Text Part 1v2 "..GetAlMightyGlobal("Idioma"),"Top")
		Text1.MoveTo(160.5, 193)
		Text2 = CreateSprite("Text Part 2v2 "..GetAlMightyGlobal("Idioma"),"Top")
		Text2.MoveTo(160.5, 193)
		BoneItem = CreateSprite("Bullets/Bones/Right Bone v2","Top")
		BoneItem.rotation = -135
		BoneItem.MoveTo(710, 193)
		timeritem = 0
	end
end

function Dodge()
	Sans.Dodge = 0
end

function Reset(bool)
	if not bool then
		if SumarEasterEgg then
			if not GetAlMightyGlobal("PilarEasterEgg") then
				SetAlMightyGlobal("PilarEasterEgg", 1)
			elseif GetAlMightyGlobal("PilarEasterEgg") < 4 then
				SetAlMightyGlobal("PilarEasterEgg", GetAlMightyGlobal("PilarEasterEgg") + 1)
			end
			SumarEasterEgg = nil
		end
	end
	if phase == 1 and progress < 6 and not bool then
		if OverworldBones then
			NoDialogBones = true
		end
		OverworldBones = true
		if string.sub(GetAlMightyGlobal("Archivimentazo"), 6, 6) == "0" then
			SetAlMightyGlobal("Archivimentazo", string.sub(GetAlMightyGlobal("Archivimentazo"), 1, 5).."1"..string.sub(GetAlMightyGlobal("Archivimentazo"), 7))
			LogroDesbloqueado = {Timer = 0, Icon = 6}
		end
		if #Items <= 1 and (Items[1] == "[starcolor:7d7d7d][color:7d7d7d]Nothing[color:ffffff]" or Items[1] == "[starcolor:7d7d7d][color:7d7d7d]Nada[color:ffffff]" or Items[1] == "[starcolor:7d7d7d][color:7d7d7d]Ничего[color:ffffff]") then
			Items = {}
		end
		if #Items + #InBox < 10 then
			for i=1,(10 - (#Items + #InBox)) do
				if GetAlMightyGlobal("Idioma") == "Spanish" then
					table.insert(InBox, "Espagueti F.")
				elseif GetAlMightyGlobal("Idioma") == "Russian" then
					table.insert(InBox, "Х. Спагетти")	
				else
					table.insert(InBox, "C. Spaghetti")
				end
			end
			Filled = true
		end
	else
		InBox = {}
		if GetAlMightyGlobal("Idioma") == "Spanish" then
			Items = {"Pay", "P. Nieve", "P. Nieve", "P. Nieve", "Héroe L.", "Héroe L.", "Héroe L.", "Héroe L."}
		elseif GetAlMightyGlobal("Idioma") == "Russian" then	
		    Items = {"Пирог", "Кус. Снег.", "Кус. Снег.", "Кус. Снег.", "Л. Герой", "Л. Герой", "Л. Герой", "Л. Герой"}
		else
			Items = {"Pie", "SnowPiece", "SnowPiece", "SnowPiece", "L. Hero", "L. Hero", "L. Hero", "L. Hero"}
		end
		Inventory.SetInventory(Items)
		NoDialogBones = nil
		OverworldBones = nil
		SetAlMightyGlobal("PilarEasterEgg", false)
	end
	phase1[6] = "Attack 6"
	enemies[1]["hp"] = 10000
	enemies[2]["hp"] = 10000
	enemies[3]["hp"] = 23000
	enemies[4]["hp"] = 1000
	GameOver = nil
	progress = 0
	phase = 1
	Volumen = 1
	Ask = nil
	local randomizador = math.random(100)
	if randomizador <= 50 then
		randomizador = math.random(100)
		if randomizador <= 50 then
			FUN = {"Rare", math.random(3)}
		elseif randomizador <= 80 then
			FUN = {"Epic", math.random(2)}
		else
			FUN = {"Legendary", math.random(3)}
		end
	else
		FUN = {"None", 0}
	end
	GameMusic = "None"
	Alternative = 0
	DialogEgg = nil
	Special = nil
	Important = nil
	posto = nil
	if EggDog.Neck then
		EggDog.Neck.Remove()
	end
	if EggDog.Head then
		EggDog.Head.Remove()
	end
	if EggDog.Body then
		EggDog.Body.Remove()
	end
	EggDog = {Animation = "None", Timer = 0}
	if Papaya then
		Papaya.Remove()
		Papaya = nil
	end
	if HeadTem then
		HeadTem.Remove()
		HeadTem = nil
	end
	if Detail then
		Detail.Remove()
		Detail = nil
	end
	if HandR then
		HandR.Remove()
		HandR = nil
	end
	if HandL then
		HandL.Remove()
		HandL = nil
	end
	if BoneL then
		BoneL.Remove()
		BoneL = nil
	end
	if BoneR then
		BoneR.Remove()
		BoneR = nil
	end
	if Brillo then
		Brillo.Remove()
		Brillo = nil
	end
	if Arms then
		Arms.Remove()
		Arms = nil
	end
	for i=1,#LegsParts do
		LegsParts[i - tableaux].Remove()
		table.remove(LegsParts, i - tableaux)
		tableaux = tableaux + 1
	end
	tableaux = 0
	fadeGlow = true
	Animation = "None"
	vel = 0
	frecuencia = 0
	GlowMax = 0.7
	GlowTimer = 0
	Spared = nil
	Done = nil
	Bad = nil
	Going = nil
	AnimationHead = nil
	AnimationHands = nil
	StopAnim = nil
	cambio = nil
	StatusPhase3 = {"", "", ""}
	if HR then
		HR.Remove()
		HR = nil
	end
	if HL then
		HL.Remove()
		HL = nil
	end
	BodySeparated = nil
	if FalseBody then
		FalseBody.Remove()
		FalseBody = nil
	end
	Player.SetAttackAnim({"UI/Battle/spr_slice_o_0","UI/Battle/spr_slice_o_1","UI/Battle/spr_slice_o_2","UI/Battle/spr_slice_o_3","UI/Battle/spr_slice_o_4","UI/Battle/spr_slice_o_5"}, 0.1)
	if Glow then
		Glow.Remove()
	end
	if Spaghetti then
		Spaghetti.Remove()
		Spaghetti = nil
	end
	if Head then
		Head.Remove()
	end
	if Jaw then
		Jaw.Remove()
	end
	if Body then
		Body.Remove()
	end
	if Legs then
		Legs.Remove()
	end
	SpawnPapyrus()
	if BG1 then
		BG1.Remove()
		BG1 = nil
	end
	if BG2 then
		BG2.Remove()
		BG2 = nil
	end
	if Sans.Head then
		Sans.Head.Remove()
	end
	if Sans.Body then
		Sans.Body.Remove()
	end
	if Sans.Legs then
		Sans.Legs.Remove()
	end
	Sans = {Animation = "None", Timer = 0, Timer2 = 0, Direction = 1}
	if Undyne.Legs then
		Undyne.Legs.Remove()
	end
	if Undyne.Dress then
		Undyne.Dress.Remove()
	end
	if Undyne.Torso then
		Undyne.Torso.Remove()
	end
	if Undyne.Arms then
		if Undyne.Arms.Left then
			Undyne.Arms.Left.Remove()
		end
		if Undyne.Arms.Right then
			Undyne.Arms.Right.Remove()
		end
	end
	if Undyne.Head then
		Undyne.Head.Remove()
	end
	if Undyne.Hair then
		Undyne.Hair.Remove()
	end
	if Undyne.Eye then
		Undyne.Eye.Remove()
	end
	Undyne = {Animation = "None", Timer = 0}
	BackgroundAnimation = nil
	RelayerUI("BelowArena")
	SetDefaultHP(19, 92)
	ConfigurateKR(true, false)
	HPEnvenenadosPorKR = 0
	Volumen = 1
	flee = true
	SelectedFlee = nil
	SelectedFlee2 = nil
	Itemed = nil
	Scared = nil
	Player.hp = 99
	Player.sprite.rotation = 0
	Player.sprite.color = {1, 0, 0}
	SetStatusDefaultPosition()
	ResetButton("Fight")
	ResetButton("Act")
	ResetButton("Item")
	ResetButton("Mercy")
	PHP = nil
	Triggered = nil
	moved = nil
	NotUsedItems = nil
	startpos = nil
	if GetAlMightyGlobal("Idioma") == "Russian" then
		enemies[1]["name"] = "Папирус"
		enemies[2]["name"] = "Санс"
		enemies[3]["name"] = "Андайн Бессмертная"
		enemies[4]["name"] = "Яйцепёс"
	else
		enemies[1]["name"] = "Papyrus"
		enemies[2]["name"] = "Sans"
		enemies[3]["name"] = "Undyne The Undying"
		enemies[4]["name"] = "Egg Dog"
	end
	enemies[1]["canspare"] = false
	enemies[1]["Teaseado"] = nil
	enemies[1]["Disculpado"] = nil
	enemies[1]["Teaseado2"] = nil
	enemies[1]["Disculpado2"] = nil
	enemies[1]["Game"] = nil
	if GetAlMightyGlobal("Idioma") == "Spanish" then
		enemies[1]["commands"] = {"Checar", "Descoquetear", "Molestar", "Disculparse"}
		enemies[2]["commands"] = {"Checar", "Patear"}
		enemies[3]["commands"] = {"Checar", "Suplicar", "Retar", "Ataque Falso"}
		enemies[4]["commands"] = {"Checar"}
		enemies[1]["noattackmisstext"] = "FALLO"
		enemies[2]["defensemisstext"] = "FALLO"
		enemies[2]["noattackmisstext"] = "FALLO"
		enemies[3]["noattackmisstext"] = "FALLO"
		enemies[4]["defensemisstext"] = "FALLO"
		enemies[4]["noattackmisstext"] = "FALLO"
	elseif GetAlMightyGlobal("Idioma") == "Russian" then
		enemies[1]["commands"] = {"Проверить", "Антифлирт", "Дразнить", "Извиниться"}
		enemies[2]["commands"] = {"Проверить", "Пнуть"}
		enemies[3]["commands"] = {"Проверить", "Молить", "Вызов", "Ложный Удар"}
		enemies[4]["commands"] = {"Проверить"}
		enemies[1]["noattackmisstext"] = "МИМО"
		enemies[2]["defensemisstext"] = "МИМО"
		enemies[2]["noattackmisstext"] = "МИМО"
		enemies[3]["noattackmisstext"] = "МИМО"
		enemies[4]["defensemisstext"] = "МИМО"
		enemies[4]["noattackmisstext"] = "МИМО"
	else
		enemies[1]["commands"] = {"Check", "Unflirt", "Tease", "Apologize"}
		enemies[2]["commands"] = {"Check", "Kick"}
		enemies[3]["commands"] = {"Check", "Plead", "Challenge", "Fake Attack"}
		enemies[4]["commands"] = {"Check"}
		enemies[1]["noattackmisstext"] = "MISS"
		enemies[2]["defensemisstext"] = "MISS"
		enemies[2]["noattackmisstext"] = "MISS"
		enemies[3]["noattackmisstext"] = "MISS"
		enemies[4]["defensemisstext"] = "MISS"
		enemies[4]["noattackmisstext"] = "MISS"
	end
	enemies[2]["Hitted"] = nil
	enemies[1]["monstersprite"].x = 0
	enemies[4]["def"] = -50
	enemies[1].Call("SetActive", true)
	enemies[2].Call("SetActive", false)
	enemies[3].Call("SetActive", false)
	nextwaves = {"Overworld/Battle"}
	State("DEFENDING")
end